package ru.yandex.direct.core.entity.keyword.service.validation;

import java.util.Map;
import java.util.Set;

import ru.yandex.direct.core.entity.keyword.container.KeywordDeleteInfo;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefects.archivedCampaignModification;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefects.campaignNoRights;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.defect.CommonDefects.objectNotFound;

public class KeywordConstraints {

    public static Constraint<Long, Defect> keywordExists(Set<Long> existingIds) {
        return fromPredicate(existingIds::contains, objectNotFound());
    }

    /**
     * Проверяет, что у оператора есть права на запись для кампании
     *
     * @param cidByKeywordId    маппинг keywordId -> campaignId
     * @param writableCampaigns кампании, для которых у текущего оператора есть права на запись
     */
    public static Constraint<Long, Defect> operatorHasRightsToChange(Map<Long, Long> cidByKeywordId,
                                                                     Set<Long> writableCampaigns) {
        return fromPredicate(id -> writableCampaigns.contains(cidByKeywordId.get(id)), campaignNoRights());
    }

    /**
     * Проверяет, что кампания не архивна
     *
     * @param keywordDeleteInfos маппинг keywordId -> информация об удаляемом keyword
     */
    public static Constraint<Long, Defect> nonArchivedCampaign(
            Map<Long, KeywordDeleteInfo> keywordDeleteInfos) {
        return fromPredicate(id -> !keywordDeleteInfos.get(id).isCampaignArchived(),
                archivedCampaignModification());
    }
}
