package ru.yandex.direct.core.entity.keyword.service.validation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.types.Identity;

public interface KeywordDefectTranslations extends TranslationBundle {

    KeywordDefectTranslations INSTANCE = I18NBundle.implement(
            KeywordDefectTranslations.class);

    @MessageFormatStub("Группа объявлений может содержать не более {0} ключевых слов")
    Translatable adGroupKeywordLimitExceeded(Identity limit);

    @MessageFormatStub("Группа объявлений находится в архиве - редактирование ключевых фраз невозможно")
    Translatable keywordModificationInArchivedAdGroup();

    @MessageFormatStub("Ключевые фразы разрешены только в рекламе текстовых и мобильных приложениях")
    Translatable keywordInNotAcceptableAdGroupType();

    @MessageFormatStub("Запрещено задавать ключевые слова в указанной группе объявлений")
    Translatable keywordForbiddenInThisAdGroup();

    @MessageFormatStub("Ключевое слово уже остановлено")
    Translatable keywordAlreadySuspendedShort();

    @MessageFormatStub("Ключевое слово не остановлено")
    Translatable keywordNotSuspendedShort();
}
