package ru.yandex.direct.core.entity.keyword.service.validation;

import ru.yandex.direct.validation.result.Defect;

public class KeywordDefects {

    public static Defect<KeywordsLimitDefectParams> maxKeywordsPerAdGroupExceeded(int maxKeywords,
                                                                                  int newKeywordsExceededCount) {
        return new Defect<>(KeywordDefectIds.Keyword.MAX_KEYWORDS_PER_AD_GROUP_EXCEEDED,
                new KeywordsLimitDefectParams()
                        .withMaxKeywords(maxKeywords)
                        .withNewKeywordsExceededCount(newKeywordsExceededCount));
    }

    public static Defect<Void> duplicatedWithExisting() {
        return new Defect<>(KeywordDefectIds.Gen.KEYWORD_DUPLICATED_WITH_EXISTING);
    }

    public static Defect<Void> duplicatedWithNew() {
        return new Defect<>(KeywordDefectIds.Gen.KEYWORD_DUPLICATED_WITH_NEW);
    }

    public static Defect<Void> duplicatedWithUpdated() {
        return new Defect<>(KeywordDefectIds.Gen.DUPLICATED_WITH_UPDATED);
    }

    public static Defect<Void> notAcceptableAdGroupType() {
        return new Defect<>(KeywordDefectIds.Gen.NOT_ACCEPTABLE_AD_GROUP_TYPE);
    }

    public static Defect<Void> adGroupNotFound() {
        return new Defect<>(KeywordDefectIds.Gen.AD_GROUP_NOT_FOUND);
    }

    static Defect<Void> keywordModificationInArchivedAdGroup() {
        return new Defect<>(KeywordDefectIds.Gen.NO_RIGHTS_IN_ARCHIVED_ADGROUP);
    }

    public static Defect<Void> keywordAlreadySuspended() {
        return new Defect<>(KeywordDefectIds.Gen.KEYWORD_ALREADY_SUSPENDED);
    }

    public static Defect<Void> keywordNotSuspended() {
        return new Defect<>(KeywordDefectIds.Gen.KEYWORD_NOT_SUSPENDED);
    }

    public static Defect<Void> autotargetingPrefixIsNotAllowed() {
        return new Defect<>(KeywordDefectIds.Gen.AUTOTARGETING_PREFIX_IS_NOT_ALLOWED);
    }
}
