package ru.yandex.direct.core.entity.keyword.service.validation;

import java.util.function.BiPredicate;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.core.entity.keyword.model.Keyword;

@ParametersAreNonnullByDefault
public class KeywordPredicates {
    /**
     * отсутствует ли у ключевой фразы поисковая ставка, нужная в стратегии
     */
    public static final BiPredicate<Keyword, DbStrategy> KEYWORD_MISSING_SEARCH_PRICE =
            (kw, dbStrategy) -> kw.getPrice() == null && dbStrategy.isSearchManualBidManaging();
    /**
     * отсутствует ли у ключевой фразы ставка в сети, нужная в стратегии
     */
    public static final BiPredicate<Keyword, DbStrategy> KEYWORD_MISSING_CONTEXT_PRICE =
            (kw, dbStrategy) -> kw.getPriceContext() == null && dbStrategy.isContextManualBidManaging();
    /**
     * отсутствует ли у ключевой фразы приоритет автобюджета, нужный в стратегии
     */
    public static final BiPredicate<Keyword, DbStrategy> KEYWORD_MISSING_AUTOBUDGET_PRIORITY =
            (kw, dbStrategy) -> kw.getAutobudgetPriority() == null && dbStrategy.isAutoBudget();
}
