package ru.yandex.direct.core.entity.keyword.service.validation;

public class KeywordsLimitDefectParams {
    private Integer maxKeywords;
    private Integer newKeywordsExceededCount;

    public Integer getMaxKeywords() {
        return maxKeywords;
    }

    public KeywordsLimitDefectParams withMaxKeywords(Integer maxKeywords) {
        this.maxKeywords = maxKeywords;
        return this;
    }

    public Number getNewKeywordsExceededCount() {
        return newKeywordsExceededCount;
    }

    public KeywordsLimitDefectParams withNewKeywordsExceededCount(Integer newKeywordsExceededCount) {
        this.newKeywordsExceededCount = newKeywordsExceededCount;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        KeywordsLimitDefectParams that = (KeywordsLimitDefectParams) o;

        if (maxKeywords != null ? !maxKeywords.equals(that.maxKeywords) : that.maxKeywords != null) {
            return false;
        }
        return newKeywordsExceededCount != null ? newKeywordsExceededCount
                .equals(that.newKeywordsExceededCount) : that.newKeywordsExceededCount == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (maxKeywords != null ? maxKeywords.hashCode() : 0);
        result = 31 * result + (newKeywordsExceededCount != null ? newKeywordsExceededCount.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "KeywordsLimitDefectParams{" +
                "maxKeywords=" + maxKeywords +
                ", newKeywordsExceededCount=" + newKeywordsExceededCount +
                '}';
    }
}
