package ru.yandex.direct.core.entity.keyword.service.validation.phrase.advqphrase;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.types.Identity;

public interface AdvqPhraseDefectTranslations extends TranslationBundle {

    AdvqPhraseDefectTranslations INSTANCE = I18NBundle.implement(AdvqPhraseDefectTranslations.class);

    @MessageFormatStub("Ключевая фраза не может содержать отдельно стоящие точки")
    Translatable invalidCharsKeywordLoneDotDetailed();

    @MessageFormatStub("Неправильное использование кавычек в ключевой фразе")
    Translatable invalidCharsUnpairedQuotesDetailed();

    @MessageFormatStub("Ключевая фраза не может состоять только из стоп-слов: союзов, предлогов, частиц")
    Translatable stopWordsDetailed();

    @MessageFormatStub("Ключевая фраза не может состоять только из минус-слов")
    Translatable minusWordsOnlyDetailed();

    @MessageFormatStub("Ключевая фраза не может состоять более чем из {0} слов")
    Translatable maxWordsDetailed(int maxWords);

    @MessageFormatStub("Длина слова в ключевой фразе не должна превышать символов")
    Translatable keywordMaxLengthDetailed(int maxLength);

    @MessageFormatStub("Неправильное использование скобок [] в ключевой фразе")
    Translatable invalidCharsUnpairedSquareBracketsDetailed();

    @MessageFormatStub("В ключевой фразе квадратные скобки [] не могут быть пустыми и вложенными")
    Translatable invalidCharsEmptyOrNestedSquareBrackets();

    @MessageFormatStub("В ключевой фразе внутри скобок [] недопустимы символы +-\"\"")
    Translatable invalidCharsModifiersInsideSquareBrackets();

    @MessageFormatStub("В ключевой фразе неправильное использование знака \"!\"")
    Translatable invalidCharsIncorrectUseOfExclamationMarks();

    @MessageFormatStub("В ключевой фразе неправильное использование знака \"-\"")
    Translatable invalidCharsIncorrectUseOfMinusSign();

    @MessageFormatStub("В ключевой фразе неправильное использование знака \"+\"")
    Translatable invalidCharsIncorrectUseOfPlusSign();

    @MessageFormatStub("Из ключевой фразы могут вычитаться только отдельные слова, а не словосочетания")
    Translatable minusWordsNoMinusPhrasesDetailed();

    @MessageFormatStub("Из ключевой фразы нельзя вычитать словосочетания, содержащие точку")
    Translatable minusWordsPhraseWithDot();

    @MessageFormatStub("В ключевой фразе неправильное сочетание специальных символов")
    Translatable minusWordsIncorrectCombinationOfSpecialSymbols();

    @MessageFormatStub("В ключевой фразе слова не могут начинаться с точек и апострофов")
    Translatable minusWordsCantStartWithDotOrApostroph();

    @MessageFormatStub("В ключевой фразе словосочетание в кавычках не может состоять из минус-слов")
    Translatable minusWordsNotInQuotedPhrase();

    @MessageFormatStub("В ключевой фразе минус-слово может содержать не более двух цифр подряд через точку")
    Translatable minusWordsSingleDotOnly();

    @MessageFormatStub("В ключевой фразе нельзя вычитать слова, содержащиеся в исходной ключевой фразе ({0}).")
    Translatable minusWordsCantSubtractPlusWords(String minusWords);

    @MessageFormatStub("Группа объявлений может содержать не более {0} ключевых слов")
    Translatable adGroupKeywordLimitExceeded(Identity limit);

    @MessageFormatStub("Группа объявлений находится в архиве - редактирование ключевых фраз невозможно")
    Translatable keywordModificationInArchivedAdGroup();

    @MessageFormatStub("В ключевой фразе неправильное использование точки")
    Translatable invalidDot();

    @MessageFormatStub("В ключевой фразе нельзя одновременно использовать кавычки и минус-слова")
    Translatable bothQuotesAndMinusWords();
}
