package ru.yandex.direct.core.entity.keyword.service.validation.phrase.advqphrase;

import java.util.List;

import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.Defect;

public class AdvqPhraseDefects {
    private AdvqPhraseDefects() {
        // no instantiation
    }

    public static Defect<Void> cannotContainLoneDot() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.CANNOT_CONTAIN_LONE_DOT);
    }

    public static Defect<Void> unpairedQuotes() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.UNPAIRED_QUOTES);
    }

    public static Defect<Void> containsOnlyStopWords() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.CONTAINS_ONLY_STOP_WORDS);
    }

    public static Defect<Void> cannotContainsOnlyMinusWords() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.CANNOT_CONTAIN_ONLY_MINUS_WORDS);
    }

    public static Defect<StringDefectParams> tooManyWords(int maxWords) {
        return new Defect<>(AdvqPhraseDefectIds.String.TOO_MANY_WORDS,
                new StringDefectParams().withMaxWords(maxWords));
    }

    public static Defect<StringDefectParams> tooLongKeyword(int maxLength) {
        return new Defect<>(AdvqPhraseDefectIds.String.TOO_LONG_KEYWORD,
                new StringDefectParams().withMaxLength(maxLength));
    }

    public static Defect<Void> unpairedSquareBrackets() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.UNPAIRED_SQUARE_BRACKETS);
    }

    public static Defect<Void> emptyOrNestedSquareBrackets() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.EMPTY_OR_NESTED_SQUARE_BRACKETS);
    }

    public static Defect<Void> modifiersInsideSquareBrackets() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.MODIFIERS_INSIDE_SQUARE_BRACKETS);
    }

    public static Defect<Void> incorrectUseOfExclamationMarks() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.INCORRECT_USE_OF_EXCLAMATION_MARK);
    }

    public static Defect<Void> incorrectUseOfMinusSign() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.INCORRECT_USE_OF_MINUS_SIGN);
    }

    public static Defect<Void> incorrectUseOfPlusSign() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.INCORRECT_USE_OF_PLUS_SIGN);
    }

    public static Defect<Void> noMinusPhrasesOnlyWords() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.NO_MINUS_PHRASES_ONLY_WORDS);
    }

    public static Defect<Void> minusWordsNoPhraseWithDot() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.MINUS_WORDS_NO_PHRASE_WITH_DOT);
    }

    public static Defect<Void> incorrectCombinationOfSpecialSymbols() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.INCORRECT_COMBINATION_OF_SPECIAL_SYMBOLS);
    }

    public static Defect<Void> minusWordCannotStartFromDotOrApostrophe() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.MINUS_WORD_CANNOT_START_FROM_DOT_OR_APOSTROPHE);
    }

    public static Defect<Void> minusWordNotInQuotedPhrase() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.MINUS_WORD_NOT_IN_QUOTED_PHRASE);
    }

    public static Defect<Void> onlySingleDotBetweenNumbers() {
        return new Defect<>(AdvqPhraseDefectIds.Gen.ONLY_SINGLE_DOT_BETWEEN_NUMBERS);
    }

    public static Defect<StringDefectParams> minusWordsCannotSubtractPlusWords(List<String> minusWords) {
        return new Defect<>(AdvqPhraseDefectIds.String.MINUS_WORDS_CANNOT_SUBTRACT_PLUS_WORDS,
                new StringDefectParams().withInvalidSubstrings(minusWords));
    }
}
