package ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;

public interface PhraseDefectTranslations extends TranslationBundle {

    PhraseDefectTranslations INSTANCE = I18NBundle.implement(PhraseDefectTranslations.class);

    @MessageFormatStub("Ключевая фраза превышает допустимую длину {0} символов: {1}")
    Translatable tooLongKeyword(int max, String phrase);

    @MessageFormatStub("Слово в ключевой фразе превышает допустимую длину {0} символов: {1}")
    Translatable tooLongWord(int max, String phrase);

    @MessageFormatStub("Некорректные символы в словах ({0}) в ключевой фразе: {1}")
    Translatable invalidChars(String phrase, String wordsConcatenated);

    @MessageFormatStub("Неправильное использование кавычек в ключевой фразе: {0}")
    Translatable invalidQuotes(String phrase);

    @MessageFormatStub("Неправильное использование квадратных скобок в ключевой фразе: {0}")
    Translatable invalidBrackets(String phrase);

    @MessageFormatStub("Неправильное использование оператора \"!\" в ключевой фразе: {0}")
    Translatable invalidExclamationMark(String phrase);

    @MessageFormatStub("Неправильное использование оператора \"+\" в ключевой фразе: {0}")
    Translatable invalidPlus(String phrase);

    @MessageFormatStub("Неправильное использование оператора \"-\" в ключевой фразе: {0}")
    Translatable invalidMinus(String phrase);

    @MessageFormatStub("Неправильное использование точки в ключевой фразе: {0}")
    Translatable invalidPoint(String phrase);

    @MessageFormatStub("Неправильное использование апострофа в ключевой фразе: {0}")
    Translatable invalidApostrophe(String phrase);

    @MessageFormatStub("Минус-слова не могут использоваться вместе с кавычками: {0}")
    Translatable bothQuotesAndMinusWords(String phrase);

    @MessageFormatStub("Минус-слова могут быть только в конце минус-фразы: {0}")
    Translatable minusWordsInsideBracketsOrQuotes(String phrase);

    @MessageFormatStub("Не допускается использование оператора \"+\" внутри квадратных скобок: {0}")
    Translatable plusMarkInsideBrackets(String phrase);

    @MessageFormatStub("Не допускается использование квадратных скобок в минус-словах: {0}")
    Translatable bracketsInMinusWords(String phrase);

    @MessageFormatStub("Допускается использование только одиночных минус-слов: {0}")
    Translatable notSingleMinusWord(String phrase);

    @MessageFormatStub("Во фразе отсутствуют плюс-слова: {0}")
    Translatable noPlusWords(String phrase);

    @MessageFormatStub("Минус-слова не должны вычитать плюс-слова: {0}")
    Translatable minusWordDeletePlusWord(String phrase);

    @MessageFormatStub("Превышено допустимое число плюс-слов ({0}) во фразе: {1}")
    Translatable tooManyWords(int max, String phrase);

    @MessageFormatStub("Ключевая фраза не может состоять только из предлогов и союзов: {0}")
    Translatable onlyStopWords(String phrase);

    @MessageFormatStub("Ошибка в использовании оператора, возможно, использованы непарные скобки")
    Translatable invalidParenthesis();
}
