package ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase;

import java.util.List;

import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.Defect;

public class PhraseDefects {

    private PhraseDefects() {
    }

    public static Defect tooLongKeyword(int maxLength) {
        return new Defect<>(PhraseDefectIds.String.TOO_LONG_KEYWORD,
                new StringDefectParams().withMaxLength(maxLength));
    }

    public static Defect<StringDefectParams> tooLongWord(int wordMaxLength, List<String> incorrectWords) {
        return new Defect<>(PhraseDefectIds.String.TOO_LONG_WORD,
                new StringDefectParams().withMaxLength(wordMaxLength).withInvalidSubstrings(incorrectWords));
    }

    public static Defect<StringDefectParams> tooLongMinusWord(int wordMaxLength,
                                                              List<String> incorrectWords) {
        return new Defect<>(PhraseDefectIds.String.TOO_LONG_MINUS_WORD,
                new StringDefectParams().withMaxLength(wordMaxLength).withInvalidSubstrings(incorrectWords));
    }

    public static Defect illegalCharacters(List<String> incorrectWords) {
        return new Defect<>(PhraseDefectIds.String.ILLEGAL_CHARACTERS,
                new StringDefectParams().withInvalidSubstrings(incorrectWords));
    }

    public static Defect invalidQuotes() {
        return new Defect<>(PhraseDefectIds.Gen.INVALID_QUOTES);
    }

    public static Defect invalidBrackets() {
        return new Defect<>(PhraseDefectIds.Gen.INVALID_BRACKETS);
    }

    public static Defect invalidExclamationMark() {
        return new Defect<>(PhraseDefectIds.Gen.INVALID_EXCLAMATION_MARK);
    }

    public static Defect invalidPlusMark() {
        return new Defect<>(PhraseDefectIds.Gen.INVALID_PLUS_MARK);
    }

    public static Defect invalidMinusMark() {
        return new Defect<>(PhraseDefectIds.Gen.INVALID_MINUS_MARK);
    }

    public static Defect invalidPoint() {
        return new Defect<>(PhraseDefectIds.Gen.INVALID_POINT);
    }

    public static Defect invalidApostrophe() {
        return new Defect<>(PhraseDefectIds.Gen.INVALID_APOSTROPHE);
    }

    public static Defect bothQuotesAndMinusWords() {
        return new Defect<>(PhraseDefectIds.Gen.BOTH_QUOTES_AND_MINUS_WORDS);
    }

    public static Defect minusWordInsideBracketsOrQuotes() {
        return new Defect<>(PhraseDefectIds.Gen.MINUS_WORD_INSIDE_BRACKETS_OR_QUOTES);
    }

    public static Defect plusMarkInBrackets() {
        return new Defect<>(PhraseDefectIds.Gen.PLUS_MARK_IN_BRACKETS);
    }

    public static Defect bracketsInMinusWords() {
        return new Defect<>(PhraseDefectIds.Gen.BRACKETS_IN_MINUS_WORDS);
    }

    public static Defect noPlusWords() {
        return new Defect<>(PhraseDefectIds.Gen.NO_PLUS_WORDS);
    }

    public static Defect notSingleMinusWord(List<String> errorPhrase) {
        return new Defect<>(PhraseDefectIds.String.NOT_SINGLE_MINUS_WORD,
                new StringDefectParams().withInvalidSubstrings(errorPhrase));
    }

    public static Defect minusWordDeletePlusWord(List<String> errorWords) {
        return new Defect<>(PhraseDefectIds.String.MINUS_WORD_DELETE_PLUS_WORD,
                new StringDefectParams()
                        .withInvalidSubstrings(errorWords));
    }

    public static Defect tooManyWords(int maxWords) {
        return new Defect<>(PhraseDefectIds.String.TOO_MANY_WORDS,
                new StringDefectParams().withMaxWords(maxWords));
    }

    public static Defect onlyStopWords() {
        return new Defect<>(PhraseDefectIds.Gen.ONLY_STOP_WORDS);
    }

    public static Defect incorrectUseOfParenthesis() {
        return new Defect<>(PhraseDefectIds.Gen.INCORRECT_USE_OF_PARENTHESIS);
    }
}
