package ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.DefaultValidator;

import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.allowedChars;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.containsPlusWords;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.maxLengthWithoutMinusExclamationAndSpaces;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.noBothQuotesAndMinusWords;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.noBracketsInMinusWords;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.noMinusWordsInsideBracketsOrQuotes;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.noPlusMarkInBrackets;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.onlySingleMinusWordsRaw;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.validApostrophe;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.validExclamationMark;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.validMinusMark;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.validPlusMark;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.validPoint;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.validQuotes;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.validSquareBrackets;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;

/**
 * Валидатор правильности синтаксиса ключевой фразы.
 * Не содержит логических проверок, которые удобнее всего проводить
 * на разобранной (parsed) ключевой фразе.
 * <p>
 * Валидатор гарантирует, что фраза может быть разобрана парсером и операторы использованы правильно.
 */
public class PhraseSyntaxValidator implements DefaultValidator<String> {

    public static PhraseSyntaxValidator keywordSyntaxValidator() {
        return new PhraseSyntaxValidator();
    }

    /**
     * Нужен для превалидации при Поиске и замены в интерфейсе
     * Сюда нужно добавлять проверки, которые подойдут для строки, которая является подстрокой фразы
     */
    public static void setCommonChecks(ItemValidationBuilder<String, Defect> vb) {
        vb.check(maxLengthWithoutMinusExclamationAndSpaces(), When.isValid())
                .check(allowedChars(), When.isValid())
                .check(validExclamationMark(), When.isValid())
                .check(validPlusMark(), When.isValid())
                .check(validMinusMark(), When.isValid())
                .check(validApostrophe(), When.isValid())
                .check(noBothQuotesAndMinusWords(), When.isValid())
                .check(noMinusWordsInsideBracketsOrQuotes(), When.isValid())
                .check(noPlusMarkInBrackets(), When.isValid())
                .check(noBracketsInMinusWords(), When.isValid())
                .check(onlySingleMinusWordsRaw(), When.isValid());
    }

    @Override
    public ValidationResult<String, Defect> apply(String keyword) {
        ItemValidationBuilder<String, Defect> vb = ItemValidationBuilder.<String, Defect>of(keyword)
                .check(notNull())
                .check(notBlank(), When.isValid());

        setCommonChecks(vb);

        return vb.check(validQuotes(), When.isValid())
                .check(validSquareBrackets(), When.isValid())
                .check(validPoint(), When.isValid())
                .check(containsPlusWords(), When.isValid())
                .getResult();
    }
}
