package ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase;

import java.util.List;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.DefaultValidator;

import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints.maxLengthKeywordsWithoutSpecSymbolsAndSpaces;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

public class MinusPhraseBeforeNormalizationValidator implements DefaultValidator<List<String>> {

    private int maxLength;
    private MinusPhraseValidator minusPhraseValidator;

    private MinusPhraseBeforeNormalizationValidator(int maxLength,
                                                    MinusPhraseValidator.ValidationMode minusPhraseValidationMode) {
        this.maxLength = maxLength;
        this.minusPhraseValidator = MinusPhraseValidator.minusKeywordIsValid(minusPhraseValidationMode);
    }

    public static MinusPhraseBeforeNormalizationValidator minusKeywordsAreValidBeforeNormalization(int maxLength,
                                                                                                   MinusPhraseValidator.ValidationMode minusPhraseValidationMode) {
        return new MinusPhraseBeforeNormalizationValidator(maxLength, minusPhraseValidationMode);
    }

    @Override
    public ValidationResult<List<String>, Defect> apply(List<String> minusKeywords) {
        return ItemValidationBuilder.of(minusKeywords, Defect.class)
                .check(notNull())
                .check(maxLengthKeywordsWithoutSpecSymbolsAndSpaces(maxLength), When.isValid())
                .checkBy(minusPhraseValidator)
                .getResult();
    }
}
