package ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase;

import ru.yandex.direct.core.validation.defects.params.CollectionSubsetDefectParams;
import ru.yandex.direct.core.validation.defects.params.StringCollectionSubsetStringDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.DefectId;

public class MinusPhraseDefectIds {

    private MinusPhraseDefectIds() {
    }

    public enum Gen implements DefectId<Void> {
        MINUS_KEYWORD_IS_INCLUDED_IN_KEYWORD,
        MINUS_WORDS_PACK_NOT_FOUND,
    }

    public enum StringLength implements DefectId<StringDefectParams> {
        MAX_LENGTH_MINUS_KEYWORDS,
    }

    public enum IndividualKeywordLength implements DefectId<StringCollectionSubsetStringDefectParams> {
        MAX_COUNT_WORDS_IN_KEYWORD,
        MAX_LENGTH_MINUS_WORD
    }

    public enum MinusPhrase implements DefectId<CollectionSubsetDefectParams<String>> {
        ILLEGAL_MINUS_KEYWORD_CHARS,
        INVALID_COMBINATION_SPECIAL_SYMBOLS,
        INVALID_DOT,
        INVALID_EXCLAMATION_MARK,
        INVALID_MINUS_MARK,
        INVALID_OPERATORS_INSIDE_SQUARE_BRACKETS,
        INVALID_PLUS_MARK,
        INVALID_WORD_FIRST_CHARACTER,
        IMBALANCED_SQUARE_BRACKETS,
        NESTED_OR_EMPTY_SQUARE_BRACKETS,
        SEPARATE_DOT,
        WRONG_QUOTES,
    }

    public enum Number implements DefectId<NumberDefectParams> {
        NEGATIVE_KEYWORD_SETS_LIMIT_EXCEEDED
    }
}
