package ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.types.Identity;

@SuppressWarnings("squid:S1214")
public interface MinusPhraseDefectTranslations extends TranslationBundle {

    MinusPhraseDefectTranslations INSTANCE = I18NBundle.implement(MinusPhraseDefectTranslations.class);

    @MessageFormatStub("В минус-фразах разрешается использовать только буквы английского, турецкого, казахского, русского, украинского или белорусского алфавита, кавычки, квадратные скобки, знаки \"-\", \"+\", \"!\", пробел.")
    Translatable notAllowedSymbolsInMinusKeywordDetailed();

    @MessageFormatStub("В минус-фразах разрешается использовать только буквы английского, турецкого, казахского, русского, украинского или белорусского алфавита, кавычки, квадратные скобки, знаки \"-\", \"+\", \"!\", пробел. Ошибки во фразах: {0}")
    Translatable notAllowedSymbolsInMinusKeywordDetailedWithList(String minusPhrases);

    @MessageFormatStub("Длина минус-фраз превышает {0} символов.")
    Translatable maxLengthMinusKeywordsDetailed(Identity maxLength);

    @MessageFormatStub("Неправильное использование кавычек в минус-фразах")
    Translatable wrongWrappedQuotesInMinusKeywordDetailed();

    @MessageFormatStub("Неправильное использование кавычек в минус-фразах: {0}")
    Translatable wrongWrappedQuotesInMinusKeywordDetailedWithList(String minusPhrases);

    @MessageFormatStub("Неправильное использование точки в минус-фразе")
    Translatable invalidDotDetailed();

    @MessageFormatStub("Минус-фразы могут содержать не более двух цифр подряд через точку. Ошибки во фразах: {0}")
    Translatable invalidDotDetailedWithList(String minusPhrases);

    @MessageFormatStub("Минус-фразы не могут содержать отдельно стоящие точки")
    Translatable separateDotDetailed();

    @MessageFormatStub("Минус-фразы не могут содержать отдельно стоящие точки: {0}")
    Translatable separateDotDetailedWithList(String minusPhrases);

    @MessageFormatStub("Превышена допустимая длина слова в минус-фразе в {0} символов")
    Translatable maxLengthWordInMinusKeywordDetailed(Identity identity);

    @MessageFormatStub("Превышена допустимая длина минус-слова")
    Translatable maxWordLengthInMinusKeywordMessage();

    @MessageFormatStub("Превышена допустимая длина слова в минус-фразе в {0} символов. Ошибки во фразах: {1}")
    Translatable maxLengthWordInMinusKeywordDetailedWithList(Identity identity, String minusPhrases);

    @MessageFormatStub("Квадратные скобки [] не могут быть пустыми, вложенными или несбалансированными")
    Translatable invalidSquareBracketsDetailed();

    @MessageFormatStub("Неправильное использование скобок [] в минус-фразах")
    Translatable imbalancedSquareBracketsDetailed();

    @MessageFormatStub("Неправильное использование скобок [] в минус-фразах: {0}")
    Translatable imbalancedSquareBracketsDetailedWithList(String minusPhrases);

    @MessageFormatStub("Квадратные скобки [] не могут быть пустыми и вложенными")
    Translatable nestedOrEmptySquareBracketsDetailed();

    @MessageFormatStub("Квадратные скобки [] не могут быть пустыми и вложенными, минус-фразы: {0}")
    Translatable nestedOrEmptySquareBracketsDetailedWithList(String minusPhrases);

    @MessageFormatStub("Внутри скобок [] недопустимы символы +-\"\", минус-фразы")
    Translatable notAllowedOperatorsInsideBracketsDetailed();

    @MessageFormatStub("Внутри скобок [] недопустимы символы +-\"\", минус-фразы: {0}")
    Translatable notAllowedOperatorsInsideBracketsDetailedWithList(String minusPhrases);

    @MessageFormatStub("Неправильное использование знака \"!\" в минус-фразе")
    Translatable wrongExclamationMarkInMinusKeyword();

    @MessageFormatStub("Неправильное использование знака \"!\" в минус-фразах: {0}")
    Translatable wrongExclamationMarkInMinusKeywordDetailed(String minusPhrases);

    @MessageFormatStub("Неправильное использование знака \"-\" в минус-фразе. Знак \"-\" нельзя использовать в начале и в конце слов")
    Translatable wrongMinusMarkUsageInMinusKeywordDetailed();

    @MessageFormatStub("Неправильное использование знака \"-\" в минус-фразах: {0}. Знак \"-\" нельзя использовать в начале и в конце слов")
    Translatable wrongMinusMarkUsageInMinusKeywordDetailedWithList(String minusPhrases);

    @MessageFormatStub("Неправильное использование знака \"+\" в минус-фразе")
    Translatable wrongPlusMarkUsageInMinusKeywordDetailed();

    @MessageFormatStub("Неправильное использование знака \"+\" в минус-фразах: {0}")
    Translatable wrongPlusMarkUsageInMinusKeywordDetailedWithList(String minusPhrases);

    @MessageFormatStub("Неправильное сочетание специальных символов в минус-фразе")
    Translatable wrongSpecialSymbolsUsageInMinusKeywordDetailed();

    @MessageFormatStub("Неправильное сочетание специальных символов в минус-фразах: {0}")
    Translatable wrongSpecialSymbolsUsageInMinusKeywordDetailedWithList(String minusPhrases);

    @MessageFormatStub("Количество слов в минус-фразе должно быть не более {0}")
    Translatable maxWordsCountInKeywordDetailed(Identity identity);

    @MessageFormatStub("Минус-фраза не может состоять более чем из {0} слов: {1}")
    Translatable maxWordsCountInKeywordDetailedWithList(Identity identity, String minusPhrases);

    @MessageFormatStub("Элемент не может присутствовать в списке более одного раза")
    Translatable duplicatedMinusPhraseShort();

    @MessageFormatStub("Элемент {0} присутствует в списке {1} более одного раза")
    Translatable duplicatedMinusPhraseDetailedWithList(String element, String nodeName);

    @MessageFormatStub("Элементы {0} присутствуют в списке {1} более одного раза")
    Translatable duplicatedMinusPhraseDetailedWithListPlural(String elements, String nodeName);

    @MessageFormatStub("Слова не могут начинаться с точек и апострофов")
    Translatable invalidWordFirstCharacterDetailed();

    @MessageFormatStub("Слова не могут начинаться с точек и апострофов: {0}")
    Translatable invalidWordFirstCharacterDetailedWithList(String minusPhrases);

    @MessageFormatStub("Слова не могут начинаться с точек и апострофов: \"{0}\"")
    Translatable invalidWordFirstCharacterDetailedWithListQuotes(String minusPhrases);

    @MessageFormatStub("Библиотечный набор минус-фраз {0} не найден")
    Translatable minusWordsPackNotFound(Identity id);

    @MessageFormatStub("Превышен лимит на наборы минус-фраз. Максимальное количество наборов: {0}")
    Translatable negativeKeywordSetsLimitExceededDetailed(int value);

}
