package ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase;

import java.util.List;

import ru.yandex.direct.core.validation.defects.params.CollectionSubsetDefectParams;
import ru.yandex.direct.core.validation.defects.params.StringCollectionSubsetStringDefectParams;
import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.Defect;

public class MinusPhraseDefects {

    private MinusPhraseDefects() {

    }

    public static Defect minusKeywordIsIncludedInKeyword() {
        return new Defect<>(MinusPhraseDefectIds.Gen.MINUS_KEYWORD_IS_INCLUDED_IN_KEYWORD);
    }

    public static Defect illegalMinusKeywordChars(List<String> minusPhrases) {
        return new Defect<>(MinusPhraseDefectIds.MinusPhrase.ILLEGAL_MINUS_KEYWORD_CHARS,
                CollectionSubsetDefectParams.of(minusPhrases));
    }

    public static Defect maxLengthMinusKeywords(int maxLength) {
        return new Defect<>(MinusPhraseDefectIds.StringLength.MAX_LENGTH_MINUS_KEYWORDS,
                new StringDefectParams().withMaxLength(maxLength));
    }

    public static Defect invalidWordFirstCharacter(List<String> minusPhrases) {
        return new Defect<>(MinusPhraseDefectIds.MinusPhrase.INVALID_WORD_FIRST_CHARACTER,
                CollectionSubsetDefectParams.of(minusPhrases));
    }

    public static Defect invalidDot(List<String> minusPhrases) {
        return new Defect<>(MinusPhraseDefectIds.MinusPhrase.INVALID_DOT,
                CollectionSubsetDefectParams.of(minusPhrases));
    }

    public static Defect separateDot(List<String> minusPhrases) {
        return new Defect<>(MinusPhraseDefectIds.MinusPhrase.SEPARATE_DOT,
                CollectionSubsetDefectParams.of(minusPhrases));
    }

    public static Defect wrongQuotes(List<String> minusPhrases) {
        return new Defect<>(MinusPhraseDefectIds.MinusPhrase.WRONG_QUOTES,
                CollectionSubsetDefectParams.of(minusPhrases));
    }

    public static Defect maxLengthMinusWord(int maxMinusWordLength, List<String> keywords) {
        return new Defect<>(MinusPhraseDefectIds.IndividualKeywordLength.MAX_LENGTH_MINUS_WORD,
                StringCollectionSubsetStringDefectParams.of(keywords).withMaxLength(maxMinusWordLength));
    }

    public static Defect maxCountWordsInKeyword(int maxLength, List<String> keywords) {
        return new Defect<>(MinusPhraseDefectIds.IndividualKeywordLength.MAX_COUNT_WORDS_IN_KEYWORD,
                StringCollectionSubsetStringDefectParams.of(keywords).withMaxWords(maxLength));
    }

    public static Defect imbalancedSquareBrackets(List<String> minusPhrases) {
        return new Defect<>(MinusPhraseDefectIds.MinusPhrase.IMBALANCED_SQUARE_BRACKETS,
                CollectionSubsetDefectParams.of(minusPhrases));
    }

    public static Defect nestedOrEmptySquareBrackets(List<String> minusPhrases) {
        return new Defect<>(MinusPhraseDefectIds.MinusPhrase.NESTED_OR_EMPTY_SQUARE_BRACKETS,
                CollectionSubsetDefectParams.of(minusPhrases));
    }

    public static Defect invalidOperatorsInsideSquareBrackets(List<String> minusPhrases) {
        return new Defect<>(MinusPhraseDefectIds.MinusPhrase.INVALID_OPERATORS_INSIDE_SQUARE_BRACKETS,
                CollectionSubsetDefectParams.of(minusPhrases));
    }

    public static Defect invalidExclamationMark(List<String> minusPhrases) {
        return new Defect<>(MinusPhraseDefectIds.MinusPhrase.INVALID_EXCLAMATION_MARK,
                CollectionSubsetDefectParams.of(minusPhrases));
    }

    public static Defect invalidMinusMark(List<String> minusPhrases) {
        return new Defect<>(MinusPhraseDefectIds.MinusPhrase.INVALID_MINUS_MARK,
                CollectionSubsetDefectParams.of(minusPhrases));
    }

    public static Defect invalidPlusMark(List<String> minusPhrases) {
        return new Defect<>(MinusPhraseDefectIds.MinusPhrase.INVALID_PLUS_MARK,
                CollectionSubsetDefectParams.of(minusPhrases));
    }

    public static Defect invalidCombinationSpecialSymbols(List<String> minusPhrases) {
        return new Defect<>(MinusPhraseDefectIds.MinusPhrase.INVALID_COMBINATION_SPECIAL_SYMBOLS,
                CollectionSubsetDefectParams.of(minusPhrases));
    }

    public static Defect minusWordsPackNotFound() {
        return new Defect<>(MinusPhraseDefectIds.Gen.MINUS_WORDS_PACK_NOT_FOUND);
    }

}
