package ru.yandex.direct.core.entity.lal

import org.springframework.stereotype.Repository
import ru.yandex.direct.core.entity.retargeting.model.Goal
import ru.yandex.direct.dbschema.ppcdict.tables.CaLalSegments
import ru.yandex.direct.dbschema.ppcdict.tables.CaLalSegments.CA_LAL_SEGMENTS
import ru.yandex.direct.dbutil.sharding.AutoIncrementKey
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder
import ru.yandex.direct.jooqmapper.ReaderWriterBuilders
import ru.yandex.direct.jooqmapperhelper.InsertHelper

@Repository
class CaLalSegmentRepository(
    private val dslContextProvider: DslContextProvider,
    private val shardHelper: ShardHelper
) {

    private val jooqMapper: JooqMapperWithSupplier<Goal> = JooqMapperWithSupplierBuilder.builder { Goal() }
        .map(ReaderWriterBuilders.property(Goal.ID, CA_LAL_SEGMENTS.ID))
        .map(ReaderWriterBuilders.property(Goal.CA_TEXT, CA_LAL_SEGMENTS.HOST))
        .map(ReaderWriterBuilders.property(Goal.CRYPTA_PARENT_RULE, CA_LAL_SEGMENTS.PARENT_RULE))
        .build()

    fun findAllByHosts(hosts: List<String>): Map<String, Goal> = dslContextProvider.ppcdict()
        .select(jooqMapper.fieldsToRead)
        .from(CA_LAL_SEGMENTS)
        .where(CA_LAL_SEGMENTS.HOST.`in`(hosts))
        .fetchMap(CA_LAL_SEGMENTS.HOST, jooqMapper::fromDb)

    fun createHostSegments(lalSegments: List<Goal>) {
        if (lalSegments.isEmpty()) return

        val generatedIds = shardHelper.generateLalSegmentIds(lalSegments.size)
        lalSegments.forEachIndexed { i, goal -> goal.id = generatedIds[i] }

        val insertHelper = InsertHelper(dslContextProvider.ppcdict(), CA_LAL_SEGMENTS)
        insertHelper.addAll(jooqMapper, lalSegments)

        insertHelper.execute()
    }

}
