package ru.yandex.direct.core.entity.landing.converter

import maps_adv.geosmb.landlord.proto.common.Common
import maps_adv.geosmb.landlord.proto.contacts.ContactsOuterClass
import maps_adv.geosmb.landlord.proto.internal.landing_details.LandingDetailsOuterClass
import maps_adv.geosmb.landlord.proto.preferences.PreferencesOuterClass
import ru.yandex.direct.core.entity.landing.model.BizContact
import ru.yandex.direct.core.entity.landing.model.BizContactType
import ru.yandex.direct.core.entity.landing.model.BizCta
import ru.yandex.direct.core.entity.landing.model.BizCtaAction

fun toContacts(
    oldContacts: ContactsOuterClass.Contacts,
    contacts: List<BizContact>
): LandingDetailsOuterClass.ContactsInput {
    val contactsBuilder = LandingDetailsOuterClass.ContactsInput.newBuilder()
    for (contact in contacts) {
        when (contact.type) {
            BizContactType.EMAIL -> contactsBuilder.setEmail(contact.value)
            BizContactType.PHONE -> {
                contactsBuilder.setPhone(contact.value)
                contactsBuilder.addAllPhones(listOf(contact.value))
            }
            BizContactType.VKONTAKTE -> contactsBuilder.setVkontakte(contact.value)
            BizContactType.TELEGRAM -> contactsBuilder.setTelegram(contact.value)
            BizContactType.VIBER -> contactsBuilder.setViber(contact.value)
            BizContactType.WHATSAPP -> contactsBuilder.setWhatsapp(contact.value)
            else -> {}
        }
    }
    contactsBuilder.setWebsite(oldContacts.website)
    contactsBuilder.setInstagram(oldContacts.instagram)
    contactsBuilder.setFacebook(oldContacts.facebook)
    contactsBuilder.setTwitter(oldContacts.twitter)
    return contactsBuilder.build()
}

fun toBlocksOptions(
    oldBlocksOptions: LandingDetailsOuterClass.BlocksOptions
): LandingDetailsOuterClass.BlocksOptions {
    return oldBlocksOptions.toBuilder().apply {
        this.showLogo = true
        this.showCover = true
    }.build()
}

fun toPreferences(
    oldPreferences: LandingDetailsOuterClass.Preferences,
    cta: BizCta
): LandingDetailsOuterClass.Preferences {
    val ctaButton = oldPreferences.ctaButton.toBuilder().setValue(cta.value)
    when (cta.action) {
        BizCtaAction.CALL -> ctaButton.setPredefined(PreferencesOuterClass.CTAButton.PredefinedType.CALL)
        BizCtaAction.REQUEST -> ctaButton.setPredefined(PreferencesOuterClass.CTAButton.PredefinedType.REQUEST)
        BizCtaAction.LINK -> ctaButton.setCustom(cta.custom)
        else -> {}
    }
    return oldPreferences.toBuilder().apply {
        this.ctaButton = ctaButton.build()
    }.build()
}

fun toImageUrl(logo: String): Common.ImageTemplate {
    return Common.ImageTemplate.newBuilder().setTemplateUrl(logo).build()
}
