package ru.yandex.direct.core.entity.landing.converter

import maps_adv.geosmb.landlord.proto.contacts.ContactsOuterClass
import maps_adv.geosmb.landlord.proto.internal.landing_details.LandingDetailsOuterClass
import maps_adv.geosmb.landlord.proto.preferences.PreferencesOuterClass
import ru.yandex.direct.core.entity.landing.model.BizContact
import ru.yandex.direct.core.entity.landing.model.BizContactType
import ru.yandex.direct.core.entity.landing.model.BizCta
import ru.yandex.direct.core.entity.landing.model.BizCtaAction

fun toContacts(contacts: ContactsOuterClass.Contacts) = listOf(
    BizContact().apply {
        type = BizContactType.EMAIL
        value = contacts.email
    },
    BizContact().apply {
        type = BizContactType.PHONE
        value = contacts.phone
    },
    BizContact().apply {
        type = BizContactType.VKONTAKTE
        value = contacts.vkontakte
    },
    BizContact().apply {
        type = BizContactType.TELEGRAM
        value = contacts.telegram
    },
    BizContact().apply {
        type = BizContactType.VIBER
        value = contacts.viber
    },
    BizContact().apply {
        type = BizContactType.WHATSAPP
        value = contacts.whatsapp
    }
)

fun toCta(preferences: LandingDetailsOuterClass.Preferences): BizCta {
    val action = when (preferences.ctaButton.predefined) {
        PreferencesOuterClass.CTAButton.PredefinedType.CALL -> BizCtaAction.CALL
        PreferencesOuterClass.CTAButton.PredefinedType.REQUEST -> BizCtaAction.REQUEST
        else -> BizCtaAction.LINK
    }
    return BizCta().apply {
        this.action = action
        custom = preferences.ctaButton.custom
        value = preferences.ctaButton.value
    }
}
