package ru.yandex.direct.core.entity.lockobject;

import java.util.concurrent.locks.Lock;

/**
 * {@link Lock}-like structure.
 */
public interface ObjectLock {

    /**
     * @return {@code true} if the lock was acquired and
     * {@code false} otherwise
     * @see Lock#lock()
     */
    boolean lock();

    /**
     * @return {@code true} if the lock was released and
     * {@code false} otherwise
     * @see Lock#unlock()
     */
    boolean unlock();

    /**
     * @return {@code true} if the lock was acquired and
     * {@code false} otherwise
     */
    boolean isLocked();
}
