package ru.yandex.direct.core.entity.lockobject;

import java.math.BigInteger;
import java.time.Duration;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.lockobject.service.LockObjectService;
import ru.yandex.direct.core.entity.model.LockObjectInfo;
import ru.yandex.direct.core.entity.model.LockObjectType;

@ParametersAreNonnullByDefault
public class PpcDictObjectLock implements ObjectLock {

    private final LockObjectService lockObjectService;
    private final long objectId;
    private final LockObjectType objectType;
    private final Long lockId;
    private final Duration duration;

    /**
     * Используется при экспорте кампании в excel файл. Хранится хеш файла.
     * Нужно для понимания что лок взять для определенного файла
     */
    private final BigInteger halfMd5Hash;

    PpcDictObjectLock(LockObjectService lockObjectService,
                      long objectId,
                      LockObjectType objectType,
                      @Nullable Long lockId,
                      Duration duration,
                      BigInteger halfMd5Hash) {
        this.lockObjectService = lockObjectService;
        this.objectId = objectId;
        this.objectType = objectType;
        this.lockId = lockId;
        this.duration = duration;
        this.halfMd5Hash = halfMd5Hash;
    }

    @Override
    public boolean lock() {
        lockObjectService.deleteLockObject(objectId, objectType, lockId);
        return lockObjectService.addLockObject(toLockObjectInfo());
    }

    @Override
    public boolean unlock() {
        return lockObjectService.deleteLockObject(objectId, objectType, lockId);
    }

    @Override
    public boolean isLocked() {
        var lockObject = lockObjectService.getLockObject(objectId, objectType, lockId);
        return lockObject != null && lockObject.getIsLocked();
    }

    private LockObjectInfo toLockObjectInfo() {
        return new LockObjectInfo()
                .withObjectId(objectId)
                .withObjectType(objectType)
                .withDuration(duration)
                .withHalfMd5Hash(halfMd5Hash);
    }
}
