package ru.yandex.direct.core.entity.lockobject;

import java.math.BigInteger;
import java.time.Duration;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.lockobject.service.LockObjectService;
import ru.yandex.direct.core.entity.model.LockObjectType;

import static com.google.common.base.Preconditions.checkArgument;

public class PpcDictObjectLockBuilder {

    static final Duration DEFAULT_LOCK_DURATION = Duration.ofMinutes(5);
    static final BigInteger DEFAULT_HALF_MD5_HASH = BigInteger.ZERO;

    private final LockObjectService lockObjectService;
    private final LockObjectType objectType;
    private final Long lockId;
    private final Duration duration;
    private final BigInteger halfMd5Hash;

    public PpcDictObjectLockBuilder(LockObjectService lockObjectService, LockObjectType objectType) {
        this(lockObjectService, objectType, null, DEFAULT_LOCK_DURATION, DEFAULT_HALF_MD5_HASH);
    }

    private PpcDictObjectLockBuilder(LockObjectService lockObjectService,
                                     LockObjectType objectType,
                                     @Nullable Long lockId,
                                     Duration duration,
                                     BigInteger halfMd5Hash) {
        checkArgument(lockObjectService != null, "lockObjectService must not be null");
        checkArgument(objectType != null, "objectType must not be null");
        checkArgument(duration != null, "duration must not be null");
        checkArgument(halfMd5Hash != null, "halfMd5Hash must not be null");
        this.lockObjectService = lockObjectService;
        this.objectType = objectType;
        this.lockId = lockId;
        this.duration = duration;
        this.halfMd5Hash = halfMd5Hash;
    }

    public PpcDictObjectLockBuilder withLockId(Long lockId) {
        return new PpcDictObjectLockBuilder(this.lockObjectService, this.objectType, lockId, this.duration, this.halfMd5Hash);
    }

    public PpcDictObjectLockBuilder withDuration(Duration duration) {
        return new PpcDictObjectLockBuilder(this.lockObjectService, this.objectType, this.lockId, duration, this.halfMd5Hash);
    }

    public PpcDictObjectLockBuilder withHalfMd5Hash(BigInteger halfMd5Hash) {
        return new PpcDictObjectLockBuilder(this.lockObjectService, this.objectType, this.lockId, this.duration, halfMd5Hash);
    }

    public ObjectLock createLock(Long objectId) {
        checkArgument(objectId != null, "objectId must not be null");
        return new PpcDictObjectLock(this.lockObjectService, objectId, this.objectType, this.lockId, this.duration, this.halfMd5Hash);
    }

}
