package ru.yandex.direct.core.entity.lockobject.service;

import javax.annotation.Nullable;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.lockobject.PpcDictObjectLockBuilder;
import ru.yandex.direct.core.entity.lockobject.repository.LockObjectRepository;
import ru.yandex.direct.core.entity.model.LockObjectInfo;
import ru.yandex.direct.core.entity.model.LockObjectType;

import static com.google.common.base.Preconditions.checkArgument;

/**
 * Сервис для работы с локами на объекты.
 * Локи хранятся в таблице {@link ru.yandex.direct.dbschema.ppcdict.Ppcdict#LOCK_OBJECT}
 */
@Service
public class LockObjectService {

    private final LockObjectRepository lockObjectRepository;

    @Autowired
    public LockObjectService(LockObjectRepository lockObjectRepository) {
        this.lockObjectRepository = lockObjectRepository;
    }

    public boolean addLockObject(LockObjectInfo lockObjectInfo) {
        checkArgument(lockObjectInfo != null, "lockObjectInfo must not be null");
        checkArgument(lockObjectInfo.getObjectId() != null, "objectId must not be null");
        checkArgument(lockObjectInfo.getObjectType() != null, "objectType must not be null");
        checkArgument(lockObjectInfo.getDuration() != null, "duration must not be null");
        checkArgument(lockObjectInfo.getDuration().getSeconds() > 0, "duration must be greater than zero");

        return lockObjectRepository.addLockObject(lockObjectInfo);
    }

    public LockObjectInfo getLockObject(Long objectId, LockObjectType objectType, @Nullable Long lockId) {
        checkArgument(objectId != null, "objectId must not be null");
        checkArgument(objectType != null, "objectType must not be null");

        return lockObjectRepository.getLockObject(objectId, objectType, lockId);
    }

    public boolean deleteLockObject(Long objectId, LockObjectType objectType, @Nullable Long lockId) {
        checkArgument(objectId != null, "objectId must not be null");
        checkArgument(objectType != null, "objectType must not be null");

        return lockObjectRepository.deleteLockObject(objectId, objectType, lockId);
    }

    public PpcDictObjectLockBuilder newCampaignLockBuilder() {
        return new PpcDictObjectLockBuilder(this, LockObjectType.CAMPAIGN);
    }

    public PpcDictObjectLockBuilder newUserLockBuilder() {
        return new PpcDictObjectLockBuilder(this, LockObjectType.USER);
    }

}
