package ru.yandex.direct.core.entity.logmail.service;

import java.time.LocalDateTime;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.log.container.LogMailsData;
import ru.yandex.direct.common.log.service.LogMailsFileService;
import ru.yandex.direct.core.entity.logmail.model.LogMail;

/**
 * Сервис для добавления логов электронных писем.
 */
@Service
@ParametersAreNonnullByDefault
public class LogMailService {

    public static final String DEAL_NOTIFICATION_TEMPLATE_NAME = "deal_notification";
    private static final String IDM_REMOVE_ROLE_TEMPLATE_NAME = "need_clear_manager_to_support";

    private final LogMailsFileService logMailsFileService;

    @Autowired
    public LogMailService(LogMailsFileService logMailsFileService) {
        this.logMailsFileService = logMailsFileService;
    }

    /**
     * Добавить лог электронного письма о сделке.
     */
    public void addDealNotificationLogMail(String email, String subject, String content) {
        addLogMail(email, subject, content, DEAL_NOTIFICATION_TEMPLATE_NAME);
    }

    public void addIdmRemoveRoleLogMail(String email, String subject, String content) {
        addLogMail(email, subject, content, IDM_REMOVE_ROLE_TEMPLATE_NAME);
    }

    private void addLogMail(String email, String subject, String content, String templateName) {
        LogMail logMail = new LogMail()
                .withEmail(email)
                .withSubject(subject)
                .withContent(content)
                .withTemplateName(templateName);
        addWithDefaults(logMail);
    }

    private void addWithDefaults(LogMail logMail) {
        logMail.withLogTime(LocalDateTime.now());

        logMailsFileService.logMails(
                List.of(new LogMailsData(
                        logMail.getEmail(), logMail.getTemplateName(),
                        logMail.getSubject(), logMail.getContent()
                ))
        );
    }
}
