package ru.yandex.direct.core.entity.mailnotification.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import static com.google.common.base.Preconditions.checkNotNull;

@ParametersAreNonnullByDefault
public class EventAdGroupParams<T> extends EventParams<T> {

    @SuppressWarnings({"FieldCanBeLocal", "unused"})
    @JsonProperty("pid")
    private final Long agGroupId;

    @SuppressWarnings({"FieldCanBeLocal", "unused"})
    @JsonProperty("group_name")
    private final String adGroupName;

    @JsonCreator
    EventAdGroupParams(
            @JsonProperty("pid") Long agGroupId,
            @JsonProperty("group_name") String adGroupName,
            @JsonProperty("old_text") T oldValue,
            @JsonProperty("new_text") T newValue) {
        super(oldValue, newValue);
        this.agGroupId = checkNotNull(agGroupId, "AdGroup ID can't be null");
        this.adGroupName = checkNotNull(adGroupName, "AdGroup name can't be null");
    }

    @Override
    protected boolean valuesEqual(T oldValue, T newValue) {
        return oldValue.equals(newValue);
    }
}
