package ru.yandex.direct.core.entity.mailnotification.model;

import java.math.BigDecimal;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class EventAdGroupPriceParams extends EventAdGroupParams<BigDecimal> {

    @JsonCreator
    EventAdGroupPriceParams(
            @JsonProperty("pid") Long adGroupId,
            @JsonProperty("group_name") String adGroupName,
            @JsonProperty("old_text") BigDecimal oldValue,
            @JsonProperty("new_text") BigDecimal newValue) {
        super(adGroupId, adGroupName, oldValue, newValue);
    }

    @Override
    protected boolean valuesEqual(BigDecimal oldValue, BigDecimal newValue) {
        return newValue.compareTo(oldValue) == 0;
    }
}
