package ru.yandex.direct.core.entity.mailnotification.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class EventCampaignParams<T> extends EventParams<T> {

    @JsonCreator
    EventCampaignParams(@JsonProperty("old_text") T oldValue, @JsonProperty("new_text") T newValue) {
        super(oldValue, newValue);
    }

    @Override
    protected boolean valuesEqual(T oldValue, T newValue) {
        return oldValue.equals(newValue);
    }
}
