package ru.yandex.direct.core.entity.mailnotification.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.utils.JsonUtils;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Параметры события {@link GenericEvent}. Преобразуются в JSON и записываются
 * в таблицу {@link ru.yandex.direct.dbschema.ppc.tables.Events#EVENTS EVENTS}
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@ParametersAreNonnullByDefault
abstract class EventParams<T> {

    @SuppressWarnings({"FieldCanBeLocal", "unused"})
    @JsonProperty("old_text")
    private final T oldValue;

    @SuppressWarnings({"FieldCanBeLocal", "unused"})
    @JsonProperty("new_text")
    private final T newValue;

    EventParams(T oldValue, T newValue) {
        checkNotNull(oldValue, "Old value can't be null");
        checkNotNull(newValue, "New value can't be null");
        checkArgument(!valuesEqual(oldValue, newValue), "New value '%s' can't be equal old '%s'", newValue, oldValue);

        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    abstract boolean valuesEqual(T oldValue, T newValue);

    String jsonValue() {
        return JsonUtils.toJson(this);
    }

    static <E extends EventParams> E fromJson(String jsonValue, Class<E> clazz) {
        return JsonUtils.fromJson(jsonValue, clazz);
    }
}
