package ru.yandex.direct.core.entity.mailnotification.model;

/**
 * Удобным представлением для {@link MailNotificationEvent} соответстувующих разным типам событий
 */
public abstract class GenericEvent {

    private final Long campaignId;
    private final Long uid;
    private final Long ownerUid;
    private final Long objectId;

    GenericEvent(Long campaignId, Long uid, Long ownerUid, Long objectId) {
        this.campaignId = campaignId;
        this.uid = uid;
        this.ownerUid = ownerUid;
        this.objectId = objectId;
    }

    public MailNotificationEvent toMailNotificationEvent() {
        return new MailNotificationEvent()
                .withOperatorUid(uid)
                .withOwnerUid(ownerUid)
                .withCampaignId(campaignId)
                .withObjectId(objectId)
                .withEventType(getEventType())
                .withObjectType(getObjectType())
                .withJsonData(getJsonData().jsonValue());
    }

    /**
     * @return тип объекта, к которому относится событие
     */
    protected abstract ObjectType getObjectType();

    /**
     * @return тип события
     */
    protected abstract EventType getEventType();

    /**
     * @return параметры события, представимые в виде JSON
     */
    protected abstract EventParams<?> getJsonData();
}
