package ru.yandex.direct.core.entity.mailnotification.model;

import java.math.BigDecimal;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class RetargetingEvent<T> extends GenericEvent {

    private ObjectType objectType;
    private EventType eventType;
    private EventAdGroupParams<T> adGroupParams;

    private RetargetingEvent(Long campaignId, Long uid, Long ownerUid, Long objectId,
                             ObjectType objectType, EventType eventType, EventAdGroupParams<T> adGroupParams) {
        super(campaignId, uid, ownerUid, objectId);
        this.objectType = objectType;
        this.eventType = eventType;
        this.adGroupParams = adGroupParams;
    }

    public static RetargetingEvent<String> addRetargetingEvent(Long operatorUid, Long ownerUid,
                                                               Long campaignId, Long adGroupId, String adGroupName, Long newValue) {
        EventAdGroupParams<String> params = new EventAdGroupParams<>(adGroupId, adGroupName, "", newValue.toString());

        return new RetargetingEvent<>(campaignId, operatorUid, ownerUid, adGroupId,
                ObjectType.ADGROUP, EventType.B_RETARGETING, params);
    }

    public static RetargetingEvent<BigDecimal> changeRetargetingPriceContextEvent(Long operatorUid, Long ownerUid,
                                                                                  Long campaignId, Long adGroupId, String adGroupName, BigDecimal oldValue, BigDecimal newValue) {
        EventAdGroupParams<BigDecimal> params = new EventAdGroupParams<>(adGroupId, adGroupName, oldValue, newValue);

        return new RetargetingEvent<>(campaignId, operatorUid, ownerUid, adGroupId,
                ObjectType.PHRASE, EventType.PH_PRICE_CTX, params);
    }

    public static RetargetingEvent<Long> changeRetargetingConditionEvent(Long operatorUid, Long ownerUid,
                                                                         Long campaignId, Long adGroupId, String adGroupName, Long oldValue, Long newValue) {
        EventAdGroupParams<Long> params = new EventAdGroupParams<>(adGroupId, adGroupName, oldValue, newValue);

        return new RetargetingEvent<>(campaignId, operatorUid, ownerUid, adGroupId,
                ObjectType.ADGROUP, EventType.B_RETARGETING, params);
    }

    public static RetargetingEvent<String> deleteRetargetingEvent(Long operatorUid, Long ownerUid,
                                                                  Long campaignId, Long adGroupId, String adGroupName, Long oldValue) {
        EventAdGroupParams<String> params = new EventAdGroupParams<>(adGroupId, adGroupName, oldValue.toString(), "");

        return new RetargetingEvent<>(campaignId, operatorUid, ownerUid, adGroupId,
                ObjectType.ADGROUP, EventType.RET_DELETE, params);
    }

    @Override
    protected ObjectType getObjectType() {
        return objectType;
    }

    @Override
    protected EventType getEventType() {
        return eventType;
    }

    @Override
    protected EventParams<?> getJsonData() {
        return adGroupParams;
    }
}
