package ru.yandex.direct.core.entity.mailnotification.model;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Событие изменения стратегии
 */
@ParametersAreNonnullByDefault
public class StrategyEvent extends GenericEvent {
    private EventStrategyParams eventStrategyParams;

    public StrategyEvent(Long campaignId, Long uid, Long ownerUid, Long campagnId,
                          EventStrategyParams eventStrategyParams) {
        super(campaignId, uid, ownerUid, campagnId);
        this.eventStrategyParams = eventStrategyParams;
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.CAMP;
    }

    @Override
    protected EventType getEventType() {
        return EventType.C_STRATEGY;
    }

    @Override
    protected EventStrategyParams getJsonData() {
        return eventStrategyParams;
    }
}
