package ru.yandex.direct.core.entity.mapping;

import java.util.Arrays;
import java.util.List;

import ru.yandex.direct.utils.JsonUtils;

public class CommonMappings {
    public static String longListToDbJsonFormat(List<Long> longList) {
        return longList == null ? null : JsonUtils.toJson(longList);
    }

    public static List<Long> longListFromDbJsonFormat(String json) {
        if (json == null) {
            return null;
        }
        return Arrays.asList(JsonUtils.fromJson(json, Long[].class));
    }

}
