package ru.yandex.direct.core.entity.masterreport

import java.math.BigDecimal
import ru.yandex.direct.bannersystem.container.masterreport.BS_PERIOD
import ru.yandex.direct.bannersystem.container.masterreport.MasterReportDimension
import ru.yandex.direct.bannersystem.container.masterreport.MasterReportGroupByDate
import ru.yandex.direct.bannersystem.container.masterreport.MasterReportMetric
import ru.yandex.direct.bannersystem.container.masterreport.MasterReportRequest
import ru.yandex.direct.bannersystem.container.masterreport.MasterReportRequest.FilterOperator
import ru.yandex.direct.bannersystem.container.masterreport.MasterReportRequest.MappingItem
import ru.yandex.direct.bannersystem.container.masterreport.MasterReportRequest.ReportColumn
import ru.yandex.direct.bannersystem.container.masterreport.dict.MasterReportCampaignPlatform
import ru.yandex.direct.bannersystem.container.masterreport.hasMultiGoalsMetric
import ru.yandex.direct.core.entity.campaign.model.CampaignAttributionModel
import ru.yandex.direct.core.entity.campaign.model.CampaignsPlatform
import ru.yandex.direct.core.entity.masterreport.model.MasterReportFilters
import ru.yandex.direct.core.entity.masterreport.model.MasterReportMapping
import ru.yandex.direct.multitype.entity.LimitOffset

private val ATTRIBUTION_MODEL_VALUES = mapOf(
        CampaignAttributionModel.LAST_CLICK to "1",
        CampaignAttributionModel.LAST_SIGNIFICANT_CLICK to "2",
        CampaignAttributionModel.FIRST_CLICK to "3",
        CampaignAttributionModel.LAST_YANDEX_DIRECT_CLICK to "4",
        CampaignAttributionModel.LAST_SIGNIFICANT_CLICK_CROSS_DEVICE to "5",
        CampaignAttributionModel.FIRST_CLICK_CROSS_DEVICE to "6",
        CampaignAttributionModel.LAST_YANDEX_DIRECT_CLICK_CROSS_DEVICE to "7"
)

private const val CONTEXT_BS_TARGET_TYPE_ID = "3"
private val TARGET_TYPE_MAPPING = mapOf(
        CONTEXT_BS_TARGET_TYPE_ID to MasterReportCampaignPlatform.CONTEXT.id.toString()
)

fun convertFilters(
        attrModel: CampaignAttributionModel?,
        filters: MasterReportFilters?,
        metrics: Set<MasterReportMetric>
): Map<ReportColumn, Map<FilterOperator, *>> {
    val result = mutableMapOf<ReportColumn, Map<FilterOperator, *>>()

    if (attrModel != null) {
        val attrModelId = ATTRIBUTION_MODEL_VALUES[attrModel]

        if (metrics.hasMultiGoalsMetric()) {
            result[ReportColumn.MULTI_GOALS_ATTRIBUTION_TYPE] = mapOf(FilterOperator.EQ to listOf(attrModelId))
        } else {
            result[ReportColumn.ATTRIBUTION_TYPE] = mapOf(FilterOperator.EQ to attrModelId)
        }
    }

    if (filters == null) {
        return result
    }

    // campaignIds && statusIn && strategyTypeIn && calcType учтены в фильтрации кампании

    if (filters.platformIn.isNotEmpty()) {
        convertPlatformFilter(filters.platformIn)?.let { result[ReportColumn.TARGET_TYPE] = it }
    }
    if (filters.regionIdsIn.isNotEmpty()) {
        result[ReportColumn.REGION_ID] = mapOf(FilterOperator.EQ to filters.regionIdsIn)
    }
    if (filters.goalIds.isNotEmpty()) {
        result[ReportColumn.MULTI_GOALS_ID] = mapOf(FilterOperator.EQ to filters.goalIds)
    }
    return result
}

fun convertMapping(
        dimensions: Set<MasterReportDimension>,
        orderIdToCampaignIds: Map<Long, Long>,
        meaningfulGoalValues: Map<String, Long>
): Map<String, MappingItem> {
    val result = mutableMapOf<String, MappingItem>()
    if (dimensions.contains(MasterReportDimension.CAMPAIGN)) {
        result[MasterReportDimension.CAMPAIGN.bsName] =
                convertMappingItem(MasterReportMapping.CAMPAIGN, orderIdToCampaignIds)
    }

    if (dimensions.contains(MasterReportDimension.PLATFORM)) {
        result[MasterReportDimension.PLATFORM.bsName] =
                convertMappingItem(MasterReportMapping.TARGET_TYPE, TARGET_TYPE_MAPPING)
    }
    result["MeaningfulGoalValue"] = convertMappingItem(MasterReportMapping.MEANINGFUL_GOAL_VALUE, meaningfulGoalValues)
    return result
}

fun convertOrderBy(
        groupByDate: MasterReportGroupByDate,
        dimensions: Set<MasterReportDimension>
): List<MasterReportRequest.OrderBy> {
    val orderBy = mutableListOf<MasterReportRequest.OrderBy>()
    if (groupByDate != MasterReportGroupByDate.NONE) {
        orderBy.add(MasterReportRequest.OrderBy().setField(BS_PERIOD))
    }
    dimensions.forEach { orderBy.add(MasterReportRequest.OrderBy().setField(it.bsName)) }
    return orderBy
}

fun convertLimits(limitOffset: LimitOffset): MasterReportRequest.Limits {
    return MasterReportRequest.Limits().setLimit(limitOffset.limit()).setOffset(limitOffset.offset())
}

private fun convertPlatformFilter(platformIn: Set<CampaignsPlatform>) =
        when {
            CampaignsPlatform.SEARCH in platformIn && CampaignsPlatform.CONTEXT !in platformIn -> {
                mapOf(FilterOperator.NE to listOf(CONTEXT_BS_TARGET_TYPE_ID))
            }
            CampaignsPlatform.SEARCH !in platformIn && CampaignsPlatform.CONTEXT in platformIn -> {
                mapOf(FilterOperator.EQ to listOf(CONTEXT_BS_TARGET_TYPE_ID))
            }
            else -> null
        }

private fun convertMappingItem(dim: MasterReportMapping, map: Map<out Any, Any>) = MappingItem()
        .setBy(dim.byName)
        .setItemDefault(dim.defaultValue)
        .setDataType(dim.dataType)
        .setMap(map.mapKeys { it.key.toString() }.mapValues { it.value.toString() })
