package ru.yandex.direct.core.entity.masterreport.model

enum class MasterReportMapping(
        /**
         * Название этого поле, которое следует использовать в фильтрации при отправке запроса в БК
         */
        val byName: String,
        /**
         * Дефолтное значение для фильтрации
         */
        val defaultValue: String,
        /**
         * Тип значений, на которые идет маппинг (для корректной сортировки в БК)
         */
        val dataType: String
) {
    GOALS("OrderIDAndGoalID", "0", "number"),
    CAMPAIGN("OrderID", "0", "number"),
    TARGET_TYPE("TargetType", "1", "number"),
    MEANINGFUL_GOAL_VALUE("OrderIDAndGoalID", "0",  "number");
}
