package ru.yandex.direct.core.entity.mdsfile.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.utils.HashingUtils;
import ru.yandex.misc.io.ByteArrayInputStreamSource;
import ru.yandex.misc.io.InputStreamSource;

@ParametersAreNonnullByDefault
public class MdsFileSaveRequest {
    private final MdsStorageType type;
    private final byte[] data;
    private final String md5Hash;
    private final String prefixPath;
    private MdsFileMetadata mdsMetadata;
    private MdsFileCustomName mdsCustomName;

    public MdsFileSaveRequest(MdsStorageType type, byte[] data, String md5Hash, @Nullable String prefixPath) {
        this.type = type;
        this.md5Hash = md5Hash;
        this.data = data;
        this.prefixPath = prefixPath;
    }

    public MdsFileSaveRequest(MdsStorageType type, byte[] data, String hash) {
        this(type, data, hash, null);
    }

    public MdsFileSaveRequest(MdsStorageType type, byte[] data) {
        this(type, data, HashingUtils.getMd5HashAsBase64YaString(data));
    }

    public MdsFileSaveRequest(MdsStorageType type, InputStreamSource inputStream) {
        this(type, inputStream.readBytes());
    }

    public MdsFileSaveRequest withCustomName(String customName) {
        this.mdsCustomName = new MdsFileCustomName().withFilename(customName);
        return this;
    }


    public MdsFileMetadata getMdsMetadata() {
        return mdsMetadata;
    }

    public void setMdsMetadata(MdsFileMetadata metadata) {
        this.mdsMetadata = metadata;
    }


    public MdsFileCustomName getMdsCustomName() {
        return mdsCustomName;
    }

    public void updateCustomNameId() {
        if (mdsCustomName == null)
            return;
        mdsCustomName.withMdsId(mdsMetadata.getId());
    }


    public InputStreamSource getInputStream() {
        return new ByteArrayInputStreamSource(this.data);
    }

    public String getMd5Hash() {
        return this.md5Hash;
    }

    public MdsStorageType getType() {
        return type;
    }

    public byte[] getData() {
        return data;
    }

    public String getMdsPath() {
        return prefixPath == null
                ? md5Hash
                : prefixPath + "/" + md5Hash;
    }
}
