package ru.yandex.direct.core.entity.measurers.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.jooq.DSLContext;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.campaign.model.CampaignMeasurer;
import ru.yandex.direct.core.entity.campaign.model.CampaignMeasurerSystem;
import ru.yandex.direct.dbschema.ppc.enums.CampMeasurersMeasurerSystem;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static java.util.Collections.emptyMap;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_MEASURERS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;

@Repository
public class CampMeasurersRepository {
    public final JooqMapperWithSupplier<CampaignMeasurer> mapper = createMapper();
    private final DslContextProvider dslContextProvider;

    public CampMeasurersRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    public Map<Long, List<CampaignMeasurer>> getMeasurersByCampaignIds(int shard, Collection<Long> campaignIds) {
        return getMeasurersByCampaignIds(dslContextProvider.ppc(shard), campaignIds);
    }

    public Map<Long, List<CampaignMeasurer>> getMeasurersByCampaignIds(DSLContext dslContext, Collection<Long> campaignIds) {
        if (campaignIds.isEmpty()) {
            return emptyMap();
        }
        return dslContext.select(CAMP_MEASURERS.CID,
                            CAMP_MEASURERS.MEASURER_SYSTEM,
                            CAMP_MEASURERS.PARAMS)
                        .from(CAMP_MEASURERS)
                        .where(CAMP_MEASURERS.CID.in(campaignIds))
                        .fetchGroups(CAMP_MEASURERS.CID, mapper::fromDb);
    }

    private static JooqMapperWithSupplier<CampaignMeasurer> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(CampaignMeasurer::new)
                .map(convertibleProperty(
                        CampaignMeasurer.MEASURER_SYSTEM,
                        CAMP_MEASURERS.MEASURER_SYSTEM,
                        CampaignMeasurerSystem::fromSource,
                        CampaignMeasurerSystem::toSource))
                .map(convertibleProperty(
                        CampaignMeasurer.PARAMS,
                        CAMP_MEASURERS.PARAMS,
                        dbValue -> dbValue == null ? "" : dbValue,
                        javaValue -> "".equals(javaValue) ? null : javaValue))
                .build();
    }

    public void enableMoat(Integer shard, List<Long> cids) {
        var insertHelper = new InsertHelper<>(dslContextProvider.ppc(shard), CAMP_MEASURERS);
        cids.forEach(cid -> insertHelper
                .set(CAMP_MEASURERS.CID, cid)
                .set(CAMP_MEASURERS.PARAMS, "{}")
                .set(CAMP_MEASURERS.MEASURER_SYSTEM, CampMeasurersMeasurerSystem.moat.moat)
                .newRecord()
        );
        insertHelper
                .onDuplicateKeyIgnore()
                .execute();
    }
}
