package ru.yandex.direct.core.entity.metrika.container;

import java.util.Objects;

public class BannerWithTitleAndBody {
    private long bid;
    private long bannerId;
    private String title;
    private String body;

    public BannerWithTitleAndBody(long bid, long bannerId, String title, String body) {
        this.bid = bid;
        this.bannerId = bannerId;
        this.title = title;
        this.body = body;
    }

    public long getBid() {
        return bid;
    }

    public long getBannerId() {
        return bannerId;
    }

    public String getTitle() {
        return title;
    }

    public String getBody() {
        return body;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BannerWithTitleAndBody that = (BannerWithTitleAndBody) o;
        return bid == that.bid &&
                bannerId == that.bannerId &&
                Objects.equals(title, that.title) &&
                Objects.equals(body, that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(bid, bannerId, title, body);
    }

    @Override
    public String toString() {
        return "BannerWithTitleAndBody{" +
                "bid=" + bid +
                ", bannerId=" + bannerId +
                ", title='" + title + '\'' +
                ", body='" + body + '\'' +
                '}';
    }
}
