package ru.yandex.direct.core.entity.metrika.container;

import java.util.Objects;
import java.util.Set;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.metrika.service.ForCampaignType;
import ru.yandex.direct.core.entity.metrika.service.MobileGoalsFilter;

public class CampaignTypeWithCounterIds {
    private MobileGoalsFilter mobileGoalsFilter;
    private Set<Long> counterIds;
    private boolean isUnavailableAutoGoalsAllowed;
    private boolean isUnavailableGoalsAllowed;

    public MobileGoalsFilter getMobileGoalsFilter() {
        return mobileGoalsFilter;
    }

    @Nullable
    public CampaignType getCampaignType() {
        if (mobileGoalsFilter != null && mobileGoalsFilter instanceof ForCampaignType) {
            return ((ForCampaignType) mobileGoalsFilter).getCampaignType();
        }
        return null;
    }

    public void setMobileGoalsFilter(MobileGoalsFilter mobileGoalsFilter) {
        this.mobileGoalsFilter = mobileGoalsFilter;
    }

    public CampaignTypeWithCounterIds withMobileGoalsFilter(MobileGoalsFilter mobileGoalsFilter) {
        setMobileGoalsFilter(mobileGoalsFilter);
        return this;
    }

    public CampaignTypeWithCounterIds withCampaignType(CampaignType campaignType) {
        setMobileGoalsFilter(new ForCampaignType(campaignType));
        return this;
    }

    public Set<Long> getCounterIds() {
        return counterIds;
    }

    public void setCounterIds(Set<Long> counterIds) {
        this.counterIds = counterIds;
    }

    public CampaignTypeWithCounterIds withCounterIds(Set<Long> counterIds) {
        setCounterIds(counterIds);
        return this;
    }

    public boolean isUnavailableAutoGoalsAllowed() {
        return isUnavailableAutoGoalsAllowed;
    }

    public void setUnavailableAutoGoalsAllowed(boolean unavailableAutoGoalsAllowed) {
        isUnavailableAutoGoalsAllowed = unavailableAutoGoalsAllowed;
    }

    public CampaignTypeWithCounterIds withUnavailableAutoGoalsAllowed(boolean unavailableAutoGoalsAllowed) {
        setUnavailableAutoGoalsAllowed(unavailableAutoGoalsAllowed);
        return this;
    }

    public boolean isUnavailableGoalsAllowed() {
        return isUnavailableGoalsAllowed;
    }

    public void setUnavailableGoalsAllowed(boolean unavailableGoalsAllowed) {
        isUnavailableGoalsAllowed = unavailableGoalsAllowed;
    }

    public CampaignTypeWithCounterIds withUnavailableGoalsAllowed(boolean unavailableGoalsAllowed) {
        setUnavailableGoalsAllowed(unavailableGoalsAllowed);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampaignTypeWithCounterIds that = (CampaignTypeWithCounterIds) o;
        return isUnavailableAutoGoalsAllowed == that.isUnavailableAutoGoalsAllowed
                && isUnavailableGoalsAllowed == that.isUnavailableGoalsAllowed
                && mobileGoalsFilter.equals(that.mobileGoalsFilter)
                && counterIds.equals(that.counterIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(mobileGoalsFilter, counterIds, isUnavailableAutoGoalsAllowed, isUnavailableGoalsAllowed);
    }
}
