package ru.yandex.direct.core.entity.metrika.container;

public class CounterIdWithDomain {
    private long counterId;
    private String domain;

    public CounterIdWithDomain(Long counterId, String domain) {
        this.counterId = counterId;
        this.domain = domain;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public long getCounterId() {
        return counterId;
    }

    public void setCounterId(long counterId) {
        this.counterId = counterId;
    }

    public CounterIdWithDomain copyWithDomain(String domain) {
        return new CounterIdWithDomain(counterId, domain);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        CounterIdWithDomain that = (CounterIdWithDomain) o;

        if (counterId != that.counterId) {
            return false;
        }
        return domain.equals(that.domain);
    }

    @Override
    public int hashCode() {
        int result = domain.hashCode();
        result = 31 * result + (int) (counterId ^ (counterId >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return "CounterIdWithDomain{" +
                "counterId=" + counterId +
                ", domain='" + domain + '\'' +
                '}';
    }
}
