package ru.yandex.direct.core.entity.metrika.container;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.model.ClientId;

@ParametersAreNonnullByDefault
public class GoalsGettingForCampaignTypeContainer {
    private final Long operatorUid;
    private final ClientId clientId;
    private final Set<Long> unAllowedInaccessibleCounterIds;

    public GoalsGettingForCampaignTypeContainer(Long operatorUid, ClientId clientId,
                                                Set<Long> unAllowedInaccessibleCounterIds) {
        this.clientId = clientId;
        this.operatorUid = operatorUid;
        this.unAllowedInaccessibleCounterIds = unAllowedInaccessibleCounterIds;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public Long getOperatorUid() {
        return operatorUid;
    }

    public Set<Long> getUnAllowedInaccessibleCounterIds() {
        return unAllowedInaccessibleCounterIds;
    }
}
