package ru.yandex.direct.core.entity.metrika.model;

import java.util.function.BiConsumer;
import java.util.function.Function;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class BannerForMetrika implements Model {
    public static final ModelProperty<BannerForMetrika, Long> BANNER_ID =
            prop("bannerId", BannerForMetrika::getBannerId, BannerForMetrika::setBannerId);
    public static final ModelProperty<BannerForMetrika, Long> BID =
            prop("bid", BannerForMetrika::getBid, BannerForMetrika::setBid);
    public static final ModelProperty<BannerForMetrika, Long> CID =
            prop("cid", BannerForMetrika::getCid, BannerForMetrika::setCid);
    public static final ModelProperty<BannerForMetrika, String> TITLE =
            prop("title", BannerForMetrika::getTitle, BannerForMetrika::setTitle);
    public static final ModelProperty<BannerForMetrika, String> BODY =
            prop("body", BannerForMetrika::getBody, BannerForMetrika::setBody);
    public static final ModelProperty<BannerForMetrika, String> DOMAIN =
            prop("domain", BannerForMetrika::getDomain, BannerForMetrika::setDomain);
    public static final ModelProperty<BannerForMetrika, Boolean> IS_IMAGE =
            prop("isImage", BannerForMetrika::getIsImage, BannerForMetrika::setIsImage);
    private Long bannerId;
    private Long bid;
    private Long cid;
    private String title;
    private String body;
    private String domain;
    private Boolean isImage;

    private static <V> ModelProperty<BannerForMetrika, V> prop(String name,
                                                               Function<BannerForMetrika, V> getter, BiConsumer<BannerForMetrika, V> setter) {
        return ModelProperty.create(BannerForMetrika.class, name, getter, setter);
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public void setBannerId(Long bannerId) {
        this.bannerId = bannerId;
    }

    public Long getBid() {
        return bid;
    }

    public void setBid(Long bid) {
        this.bid = bid;
    }

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public Boolean getIsImage() {
        return isImage;
    }

    public void setIsImage(Boolean isImage) {
        this.isImage = isImage;
    }

    public BannerForMetrika withIsImage(Boolean image) {
        isImage = image;
        return this;
    }

}
