package ru.yandex.direct.core.entity.metrika.model;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class CampaignForMetrika implements Model, CampaignWithCounterForMetrika {

    public static final ModelProperty<CampaignForMetrika, Long> ID =
            prop("id", CampaignForMetrika::getId, CampaignForMetrika::setId);
    public static final ModelProperty<CampaignForMetrika, String> NAME =
            prop("name", CampaignForMetrika::getName, CampaignForMetrika::setName);
    public static final ModelProperty<CampaignForMetrika, CurrencyCode> CURRENCY =
            prop("currency", CampaignForMetrika::getCurrency, CampaignForMetrika::setCurrency);
    public static final ModelProperty<CampaignForMetrika, Long> CLIENT_ID =
            prop("clientId", CampaignForMetrika::getClientId, CampaignForMetrika::setClientId);
    public static final ModelProperty<CampaignForMetrika, Long> ORDER_ID =
            prop("orderId", CampaignForMetrika::getOrderId, CampaignForMetrika::setOrderId);
    public static final ModelProperty<CampaignForMetrika, Boolean> STATUS_CLICK_TRACK =
            prop("hasAddMetrikaTagToUrl", CampaignForMetrika::getHasAddMetrikaTagToUrl,
                    CampaignForMetrika::setHasAddMetrikaTagToUrl);
    public static final ModelProperty<CampaignForMetrika, List<Long>> METRIKA_COUNTERS =
            prop("metrikaCounters", CampaignForMetrika::getMetrikaCounters, CampaignForMetrika::setMetrikaCounters);

    private Long id;
    private String name;
    private CurrencyCode currency;
    private Long clientId;
    private Long orderId;
    private Boolean hasAddMetrikaTagToUrl;
    /**
     * "Белый список" счётчиков, к визитам которых следует клеить клики с этой кампании
     * Если список пуст и включена провязка по yclid, клики будут клеиться ко всем счётчикам сайта
     */
    private List<Long> metrikaCounters;

    private static <V> ModelProperty<CampaignForMetrika, V> prop(String name,
                                                                 Function<CampaignForMetrika, V> getter,
                                                                 BiConsumer<CampaignForMetrika, V> setter) {
        return ModelProperty.create(CampaignForMetrika.class, name, getter, setter);
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CurrencyCode getCurrency() {
        return currency;
    }

    public void setCurrency(CurrencyCode currency) {
        this.currency = currency;
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Boolean getHasAddMetrikaTagToUrl() {
        return hasAddMetrikaTagToUrl;
    }

    public void setHasAddMetrikaTagToUrl(Boolean hasAddMetrikaTagToUrl) {
        this.hasAddMetrikaTagToUrl = hasAddMetrikaTagToUrl;
    }

    public List<Long> getMetrikaCounters() {
        return metrikaCounters;
    }

    public void setMetrikaCounters(List<Long> metrikaCounters) {
        this.metrikaCounters = metrikaCounters;
    }
}
