package ru.yandex.direct.core.entity.metrika.model;

import java.util.function.BiConsumer;
import java.util.function.Function;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class DynamicForMetrika implements Model {
    public static final ModelProperty<DynamicForMetrika, Long> CONDITION_ID = ModelProperty.create(
            DynamicForMetrika.class, "conditionId", DynamicForMetrika::getConditionId,
            DynamicForMetrika::setConditionId);

    public static final ModelProperty<DynamicForMetrika, String> CONDITION_NAME =
            prop("conditionName", DynamicForMetrika::getConditionName,
                    DynamicForMetrika::setConditionName);

    private Long conditionId;
    private String conditionName;

    private static <V> ModelProperty<DynamicForMetrika, V> prop(String name,
                                                                Function<DynamicForMetrika, V> getter, BiConsumer<DynamicForMetrika, V> setter) {
        return ModelProperty.create(DynamicForMetrika.class, name, getter, setter);
    }

    public Long getConditionId() {
        return conditionId;
    }

    public void setConditionId(Long conditionId) {
        this.conditionId = conditionId;
    }

    public String getConditionName() {
        return conditionName;
    }

    public void setConditionName(String conditionName) {
        this.conditionName = conditionName;
    }
}
