package ru.yandex.direct.core.entity.metrika.model.objectinfo;

import java.time.LocalDateTime;

/**
 * Единый объект для представления баннеров и картиночных баннеров для Метрики
 */
public class BannerInfoForMetrika {

    private Long sortId;
    private Long bannerId;
    private Long bsBannerId;
    private String title;
    private String body;
    private LocalDateTime lastChange;

    public Long getSortId() {
        return sortId;
    }

    public void setSortId(Long sortId) {
        this.sortId = sortId;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public void setBannerId(Long bannerId) {
        this.bannerId = bannerId;
    }

    public Long getBsBannerId() {
        return bsBannerId;
    }

    public void setBsBannerId(Long bsBannerId) {
        this.bsBannerId = bsBannerId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public LocalDateTime getLastChange() {
        return lastChange;
    }

    public void setLastChange(LocalDateTime lastChange) {
        this.lastChange = lastChange;
    }

    public BannerInfoForMetrika withSortId(Long sortId) {
        this.sortId = sortId;
        return this;
    }

    public BannerInfoForMetrika withBannerId(Long bannerId) {
        this.bannerId = bannerId;
        return this;
    }

    public BannerInfoForMetrika withBsBannerId(Long bsBannerId) {
        this.bsBannerId = bsBannerId;
        return this;
    }

    public BannerInfoForMetrika withTitle(String title) {
        this.title = title;
        return this;
    }

    public BannerInfoForMetrika withBody(String body) {
        this.body = body;
        return this;
    }

    public BannerInfoForMetrika withLastChange(LocalDateTime lastChange) {
        this.lastChange = lastChange;
        return this;
    }
}
