package ru.yandex.direct.core.entity.metrika.repository

import org.slf4j.LoggerFactory
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Repository
import ru.yandex.direct.grid.schema.yt.Tables
import ru.yandex.direct.ytcomponents.service.CalltrackingExternalByDomainDynContextProvider
import ru.yandex.direct.ytwrapper.YtTableUtils
import ru.yandex.direct.ytwrapper.dynamic.dsl.YtDSL
import java.time.Duration
import java.time.LocalDateTime
import java.time.ZoneOffset

@Repository
class CalltrackingExternalRepository @Autowired constructor(
    private val dynContextProvider: CalltrackingExternalByDomainDynContextProvider
) {
    companion object {
        private val logger = LoggerFactory.getLogger(CalltrackingExternalRepository::class.java)
        private val EXTERNAL_CALLTRACKING_BY_DOMAIN = Tables.EXTERNAL_CALLTRACKING_BY_DOMAIN.`as`("C")
        private val DOMAIN_FIELD = YtTableUtils.aliased(EXTERNAL_CALLTRACKING_BY_DOMAIN.DOMAIN)
    }

    /**
     * Получить список доменов среди `domains`, на которых найдены скрипты сторонних
     * коллтрекингов за период `period`
     */
    fun getExternalCalltrackingDomains(domains: Collection<String>, period: Duration): Set<String> {
        if (domains.isEmpty()) {
            return emptySet()
        }
        return try {
            val periodTimestamp = LocalDateTime.now().minus(period).toEpochSecond(ZoneOffset.UTC)
            val query = YtDSL.ytContext()
                .select(DOMAIN_FIELD)
                .from(EXTERNAL_CALLTRACKING_BY_DOMAIN)
                .where(EXTERNAL_CALLTRACKING_BY_DOMAIN.DOMAIN.`in`(domains))
                .and(EXTERNAL_CALLTRACKING_BY_DOMAIN.TIMESTAMP.greaterThan(periodTimestamp))
            val rowset = dynContextProvider.context.executeTimeoutSafeSelect(query)
            rowset.rows
                .mapTo(HashSet()) { YtTableUtils.stringValueGetter(rowset.schema, DOMAIN_FIELD).apply(it) }
        } catch (e: RuntimeException) {
            logger.error("Failed to get external calltracking for $domains", e)
            emptySet()
        }
    }

}
