package ru.yandex.direct.core.entity.metrika.repository;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.direct.ytwrapper.model.YtSQLSyntaxVersion;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;

@Repository
public class CalltrackingNumberCallsRepository {

    private final YtProvider ytProvider;
    private static final String YQL_QUERY = String.join("\n",
            new ClassPathResourceInputStreamSource("calltracking/CalltrackingGetLastCallTimes.sql").readLines()
    );
    private static final YtCluster CLUSTER = YtCluster.HAHN;
    private static final String TO_PHONE_FIELD = "to_phone";
    private static final String LAST_CALL_TIME_FIELD = "last_call_time";

    @Autowired
    public CalltrackingNumberCallsRepository(YtProvider ytProvider) {
        this.ytProvider = ytProvider;
    }

    /**
     * Получить все телефоны Телефонии и последний момент звонка на них из YT
     */
    public Map<String, LocalDateTime> getLastCallTimesByPhones(
            LocalDateTime now,
            LocalDateTime nowMinusMaxDaysWithoutActions,
            List<String> phones) {
        Map<String, LocalDateTime> lastCallTimeByPhones = new HashMap<>();
        String nowDate = now.toLocalDate().toString();
        String nowDateMinusMaxDaysWithoutActions = nowMinusMaxDaysWithoutActions.toLocalDate().toString();
        String phonesString = String.format("('%s')", String.join("', '", phones));
        String resultYQLQuery = String.format(YQL_QUERY, phonesString);
        ytProvider.getOperator(CLUSTER, YtSQLSyntaxVersion.SQLv1)
                .yqlQuery(resultYQLQuery, rs -> {
                            lastCallTimeByPhones.put(
                                    rs.getString(TO_PHONE_FIELD),
                                    ZonedDateTime.parse(rs.getString(LAST_CALL_TIME_FIELD)).toLocalDateTime());
                            return null;
                        },
                        nowDateMinusMaxDaysWithoutActions,
                        nowDate);
        return lastCallTimeByPhones;
    }
}
