package ru.yandex.direct.core.entity.metrika.service;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;

@SuppressWarnings("squid:S1214")
public interface MetrikaSegmentPresetTranslations extends TranslationBundle {

    MetrikaSegmentPresetTranslations INSTANCE = I18NBundle.implement(MetrikaSegmentPresetTranslations.class);

    @MessageFormatStub("Новые посетители")
    Translatable newUsers();

    @MessageFormatStub("Вернувшиеся посетители")
    Translatable oldUser();

    @MessageFormatStub("Поисковый трафик")
    Translatable organicTrafficSource();

    @MessageFormatStub("Рекламный трафик")
    Translatable adTrafficSource();

    @MessageFormatStub("Ссылочный трафик")
    Translatable referralTrafficSource();

    @MessageFormatStub("Отказы")
    Translatable bounce();

    @MessageFormatStub("Неотказы")
    Translatable notBounce();

    @MessageFormatStub("Трафик с мобильных устройств")
    Translatable mobileTraffic();

    @MessageFormatStub("Трафик с desktop устройств")
    Translatable desktopTraffic();

    @MessageFormatStub("Покупатели")
    Translatable ecomPurchase();

    @MessageFormatStub("Брошенные корзины")
    Translatable ecomAbandonedCart();

    @MessageFormatStub("Смотрели товары, но не купили")
    Translatable ecomViewedWithoutPurchase();
}
