package ru.yandex.direct.core.entity.metrika.service;

import java.util.Map;
import java.util.function.BiPredicate;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.GoalStatus;
import ru.yandex.direct.core.entity.retargeting.model.MetrikaCounterGoalType;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.rbac.RbacRole;

import static java.util.Map.entry;

@Service
public class MobileGoalsPermissionService {

    @Autowired
    private FeatureService featureService;

    @Autowired
    private TranslationService translationService;

    private static final MobileGoalsTranslations translations = MobileGoalsTranslations.INSTANCE;

    // Роли, фичи и их расхождение со старым интерфейсом будет разбираться в  https://st.yandex-team.ru/DIRECT-123124
    private static final BiPredicate<RbacRole, ClientId> IS_SUPER_OR_MANAGER =
            (role, clientId) -> role == RbacRole.MANAGER || role == RbacRole.SUPER;
    private static final BiPredicate<RbacRole, ClientId> IS_INTERNAL_ROLE_OR_MANAGER =
            (role, clientId) -> role == RbacRole.MANAGER || role.isInternal();
    private static final BiPredicate<RbacRole, ClientId> ALWAYS_TRUE =
            (role, clientId) -> true;
    private final BiPredicate<RbacRole, ClientId> isSuperOrManagerOrRmpTrackerFeatureEnabled =
            IS_SUPER_OR_MANAGER.or((role, clientId) ->
                    featureService.isEnabledForClientId(clientId, FeatureName.RMP_STAT_TRACKER_INSTALL_ENABLED));
    private final BiPredicate<RbacRole, ClientId> isSuperOrManagerOrRmpAssociatedInstallsFeatureEnabled =
            IS_SUPER_OR_MANAGER.or((role, clientId) ->
                    featureService.isEnabledForClientId(clientId, FeatureName.RMP_STAT_ASSOCIATED_INSTALL_ENABLED));
    private final BiPredicate<RbacRole, ClientId> isInternalRoleOrManagerOrRmpFeaturesEnabled =
            IS_INTERNAL_ROLE_OR_MANAGER.or((role, clientId) ->
                    featureService.isEnabledForClientId(clientId, FeatureName.RMP_STAT_CPA_ENABLED)
                            || featureService.isEnabledForClientId(clientId, FeatureName.IN_APP_EVENTS_IN_RMP_ENABLED));

    public Map<Goal, BiPredicate<RbacRole, ClientId>> getMobileGoalsWithPermissions() {
        return Map.ofEntries(
                entry((Goal) new Goal()
                                .withId(3L)
                                .withName(translationService.translate(translations.appInstallsAntifraud()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        IS_SUPER_OR_MANAGER),
                entry((Goal) new Goal()
                                .withId(4L)
                                .withName(translationService.translate(translations.appInstalls()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        ALWAYS_TRUE),
                entry((Goal) new Goal()
                                .withId(5L)
                                .withName(translationService.translate(translations.appInstallsTracker()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isSuperOrManagerOrRmpTrackerFeatureEnabled),
                entry((Goal) new Goal()
                                .withId(6L)
                                .withName(translationService.translate(translations.assistedAppInstalls()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isSuperOrManagerOrRmpAssociatedInstallsFeatureEnabled),
                entry((Goal) new Goal()
                                .withId(7L)
                                .withName(translationService.translate(translations.assistedAppInstallsWithoutReinstalls()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isSuperOrManagerOrRmpAssociatedInstallsFeatureEnabled),
                entry((Goal) new Goal()
                                .withId(38402972L)
                                .withName(translationService.translate(translations.achieved()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403008L)
                                .withName(translationService.translate(translations.appLaunched()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403053L)
                                .withName(translationService.translate(translations.addedPaymentInfo()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403071L)
                                .withName(translationService.translate(translations.addedToCart()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403080L)
                                .withName(translationService.translate(translations.addedToWishList()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403095L)
                                .withName(translationService.translate(translations.completedRegistration()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403104L)
                                .withName(translationService.translate(translations.completedTutorial()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403131L)
                                .withName(translationService.translate(translations.initiatedCheckout()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403173L)
                                .withName(translationService.translate(translations.purchased()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403191L)
                                .withName(translationService.translate(translations.rated()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403197L)
                                .withName(translationService.translate(translations.searched()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403206L)
                                .withName(translationService.translate(translations.spentCredits()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403215L)
                                .withName(translationService.translate(translations.unlockedAchievement()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403230L)
                                .withName(translationService.translate(translations.viewedContent()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403338L)
                                .withName(translationService.translate(translations.spentTimeInApp()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403494L)
                                .withName(translationService.translate(translations.shared()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403530L)
                                .withName(translationService.translate(translations.event1()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403545L)
                                .withName(translationService.translate(translations.event2()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled),
                entry((Goal) new Goal()
                                .withId(38403581L)
                                .withName(translationService.translate(translations.event3()))
                                .withMetrikaCounterGoalType(MetrikaCounterGoalType.ACTION)
                                .withStatus(GoalStatus.ACTIVE),
                        isInternalRoleOrManagerOrRmpFeaturesEnabled)
        );
    }
}
