package ru.yandex.direct.core.entity.metrika.service.commongoals

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.metrika.client.MetrikaClient
import ru.yandex.direct.metrika.client.model.request.UserCountersExtendedFilter
import ru.yandex.direct.metrika.client.model.response.UserCountersExtended
import ru.yandex.direct.rbac.RbacService

@Service
class CommonCountersService @Autowired constructor(
    private val metrikaClient: MetrikaClient,
    private val rbacService: RbacService
) {
    fun getAvailableCountersFromMetrika(clientId: ClientId, counterIds: List<Long>): List<UserCountersExtended> {
        val clientRepresentativesUids = rbacService.getClientRepresentativesUidsForGetMetrikaCounters(clientId)
        return metrikaClient.getUsersCountersNumExtended2(
            clientRepresentativesUids,
            UserCountersExtendedFilter().withCounterIds(counterIds)
        ).users
    }
}
