package ru.yandex.direct.core.entity.metrika.service.validation;

import java.util.Set;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefects.metrikaCounterIsUnavailable;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

public class MetrikaCountersValidationService {

    public static ValidationResult<Long, Defect> validateCounterId(Long counterId, Set<Long> availableCounters) {
        ItemValidationBuilder<Long, Defect> vb = ItemValidationBuilder.of(counterId);

        vb.check(notNull())
                .check(validId(), When.isValid())
                .check(inSet(availableCounters), metrikaCounterIsUnavailable(), When.isValid());

        return vb.getResult();
    }
}
