package ru.yandex.direct.core.entity.metrika.utils

import ru.yandex.direct.core.entity.campaign.model.CampaignAttributionModel
import ru.yandex.direct.metrika.client.internal.Attribution

class AttributionConverter {
    companion object {
        @JvmStatic
        fun coreToMetrika(from: CampaignAttributionModel?): Attribution? {
            return when (from) {
                null -> null
                CampaignAttributionModel.FIRST_CLICK -> Attribution.FIRST
                CampaignAttributionModel.LAST_CLICK -> Attribution.LAST
                CampaignAttributionModel.LAST_SIGNIFICANT_CLICK -> Attribution.LASTSIGN
                CampaignAttributionModel.LAST_YANDEX_DIRECT_CLICK -> Attribution.LAST_YANDEX_DIRECT_CLICK

                CampaignAttributionModel.FIRST_CLICK_CROSS_DEVICE -> Attribution.CROSS_DEVICE_FIRST
                CampaignAttributionModel.LAST_SIGNIFICANT_CLICK_CROSS_DEVICE -> Attribution.CROSS_DEVICE_LAST_SIGNIFICANT
                CampaignAttributionModel.LAST_YANDEX_DIRECT_CLICK_CROSS_DEVICE -> Attribution.CROSS_DEVICE_LAST_YANDEX_DIRECT_CLICK
            }
        }

        @JvmStatic
        fun metrikaToCore(from: Attribution?): CampaignAttributionModel? {
            return when (from) {
                null -> null
                Attribution.FIRST -> CampaignAttributionModel.FIRST_CLICK
                Attribution.LAST -> CampaignAttributionModel.LAST_CLICK
                Attribution.CROSS_DEVICE_LAST -> CampaignAttributionModel.LAST_CLICK
                Attribution.LASTSIGN -> CampaignAttributionModel.LAST_SIGNIFICANT_CLICK
                Attribution.LAST_YANDEX_DIRECT_CLICK -> CampaignAttributionModel.LAST_YANDEX_DIRECT_CLICK
                Attribution.CROSS_DEVICE_FIRST -> CampaignAttributionModel.FIRST_CLICK_CROSS_DEVICE
                Attribution.CROSS_DEVICE_LAST_SIGNIFICANT -> CampaignAttributionModel.LAST_SIGNIFICANT_CLICK_CROSS_DEVICE
                Attribution.CROSS_DEVICE_LAST_YANDEX_DIRECT_CLICK -> CampaignAttributionModel.LAST_YANDEX_DIRECT_CLICK_CROSS_DEVICE
                Attribution.UNKNOWN -> throw IllegalArgumentException("Can't convert UNKNOWN attribution")
            }
        }
    }
}
