package ru.yandex.direct.core.entity.metrika.utils;

import javax.annotation.Nullable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.audience.client.model.AudienceSegment;
import ru.yandex.direct.audience.client.model.SegmentStatus;
import ru.yandex.direct.core.entity.adgroup.model.ExternalAudienceStatus;
import ru.yandex.direct.core.entity.metrika.model.Segment;

public class YaAudienceConverter {
    private static final Logger logger = LoggerFactory.getLogger(YaAudienceConverter.class);

    private YaAudienceConverter() {
    }

    public static Segment convertSegment(AudienceSegment audienceSegment) {
        return new Segment()
                .withId(audienceSegment.getId())
                .withStatus(convertStatus(audienceSegment.getStatus()));
    }

    private static ExternalAudienceStatus convertStatus(@Nullable SegmentStatus segmentStatus) {
        if (segmentStatus == null) {
            return null;
        }
        switch (segmentStatus) {
            //статусов нет в нашем enum, но для нас важно, что сегмент еще не надо пытаться обновлять
            case UPLOADED:
            case IS_UPDATED:
            case IS_PROCESSED:
                return ExternalAudienceStatus.IS_PROCESSED;
            case PROCESSED:
                return ExternalAudienceStatus.PROCESSED;
            case PROCESSING_FAILED:
                return ExternalAudienceStatus.PROCESSING_FAILED;
            case FEW_DATA:
                return ExternalAudienceStatus.FEW_DATA;
            default:
                logger.error("Unknown audience status {}", segmentStatus.name());
                return null;
        }
    }
}
